/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia.borders;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import net.sourceforge.mlf.metouia.borders.MetouiaDotsBuffer;

public class MetouiaDots
implements Icon {
    protected int xDots;
    protected int yDots;
    protected MetouiaDotsBuffer buffer;

    public MetouiaDots(int width, int height) {
        this.setDotsArea(width, height);
        if (this.buffer == null) {
            this.buffer = new MetouiaDotsBuffer();
        }
    }

    public void setDotsArea(int width, int height) {
        this.xDots = width / 5;
        this.yDots = height / 5;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int bufferWidth = this.buffer.getImageSize().width;
        int bufferHeight = this.buffer.getImageSize().height;
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        int x2 = x + iconWidth;
        int y2 = y + iconHeight;
        int savex = x;
        while (y < y2) {
            int h = Math.min(y2 - y, bufferHeight);
            x = savex;
            while (x < x2) {
                int w = Math.min(x2 - x, bufferWidth);
                g.drawImage(this.buffer.getImage(), x, y, x + w, y + h, 0, 0, w, h, null);
                x += bufferWidth;
            }
            y += bufferHeight;
        }
    }

    public int getIconWidth() {
        return this.xDots * 5;
    }

    public int getIconHeight() {
        return this.yDots * 5;
    }
}

