/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.guvnor.common.services.backend.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

import org.guvnor.common.services.backend.preferences.ApplicationPreferencesLoader;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationPreferencesLoader implements ApplicationPreferencesLoader {

    @Inject
    private ConfigurationService configurationService;

    private static final Logger log = LoggerFactory.getLogger( DefaultApplicationPreferencesLoader.class );

    @Override
    public Map<String, String> load() {
        final Map<String, String> preferences = new HashMap<String, String>();
        final List<ConfigGroup> configs = configurationService.getConfiguration( ConfigType.GLOBAL );
        for ( ConfigGroup config : configs ) {
            for ( ConfigItem item : config.getItems() ) {
                final String name = item.getName();
                final String value = config.getConfigItemValue( name );
                log.info( "Setting preference '" + name + "' to '" + value + "'." );
                preferences.put( name,
                                 value );
            }
        }
        return preferences;
    }

}
