/*
 * Copyright 2015 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.guvnor.common.services.backend.file;

import org.uberfire.java.nio.file.Files;
import org.uberfire.commons.validation.PortablePreconditions;

/**
 * A Filter only accepting files with the given file extension
 */
public class FileExtensionFilter extends DotFileFilter {

    private String extension;

    public FileExtensionFilter( final String extension ) {
        this.extension = PortablePreconditions.checkNotNull( "extension",
                                                             extension );
        if ( !extension.startsWith( "." ) ) {
            this.extension = "." + extension;
        }
    }

    @Override
    public boolean accept( final org.uberfire.java.nio.file.Path path ) {
        boolean accept = super.accept( path );
        if ( accept ) {
            return false;
        }
        if ( !Files.isRegularFile( path ) ) {
            return false;
        }
        final String uri = path.toUri().toString();
        if ( uri.substring( uri.length() - extension.length() ).equals( extension ) ) {
            return true;
        }
        return false;
    }

}
