package org.jboss.brmsbpmsuite.patching.phase;

import org.jboss.brmsbpmsuite.patching.client.DistributionPatcher;

import java.io.File;
import java.io.IOException;

public class DistributionPatchingPhaseRunner implements PatchingPhaseRunner {
    private final DistributionPatcher patcher;
    private final PatchingPhaseRunner delegate;

    public DistributionPatchingPhaseRunner(DistributionPatcher patcher, File backupDir) {
        this.patcher = patcher;
        this.delegate = new BasePatchingPhaseRunner(patcher, backupDir);
    }

    @Override
    public void run(PatchingPhase phase) throws IOException {
        switch (phase) {
            case CHECK_DISTRO:
                patcher.checkDistro();
                break;
            case CHECK_VERSION:
                patcher.checkVersion();
                break;
            case EXPLODE_WAR:
                patcher.explodeWar();
                break;
            case ZIP_WAR:
                patcher.zipWar();
            default:
                delegate.run(phase);
        }
    }
}
