/*
 * Copyright 2014 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.optaplanner.examples.cheaptime.domain;

import org.optaplanner.examples.common.domain.AbstractPersistable;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("CtTaskRequirement")
public class TaskRequirement extends AbstractPersistable {

    private Resource resource;
    private int resourceUsage;

    public TaskRequirement() {

    }

    public TaskRequirement(long id, Resource resource, int resourceUsage) {
        super(id);
        this.resource = resource;
        this.resourceUsage = resourceUsage;
    }

    public Resource getResource() {
        return resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public int getResourceUsage() {
        return resourceUsage;
    }

    public void setResourceUsage(int resourceUsage) {
        this.resourceUsage = resourceUsage;
    }

    // ************************************************************************
    // Complex methods
    // ************************************************************************

}
