package com.izforge.izpack.util;

import com.izforge.izpack.panels.ProcessingClient;

import java.util.Map;
import java.util.regex.Pattern;

/**
 * Created by eunderhi on 02/06/15.
 * The same as the regular expression validator but
 * allows for validation of different fields by specifying
 * a fieldnumber parameter (it doesn't just pick field 0).
 */
public class FieldNumberRegularExpressionValidator extends RegularExpressionValidator{

    String FIELDNUMBER_PARAM = "fieldnumber";

    int FIELDNUMBER_DEFUALT = 0;

    public static final String STR_PATTERN_DEFAULT = "[a-zA-Z0-9._-]{3,}@[a-zA-Z0-9._-]+([.][a-zA-Z0-9_-]+)*[.][a-zA-Z0-9._-]{2,4}";

    private static final String PATTERN_PARAM = "pattern";

    public Status validate(ProcessingClient client)
    {
        Status failureStatus = Status.ERROR;

        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get(WARNING_PARAM)))
            failureStatus = Status.WARNING;

        String patternString;

        if (client.hasParams())
        {
            Map<String, String> paramMap = client.getValidatorParams();
            patternString = paramMap.get(PATTERN_PARAM);
        }
        else
        {
            patternString = STR_PATTERN_DEFAULT;
        }
        Pattern pattern = Pattern.compile(patternString);
        boolean validationResult = pattern.matcher(getString(client)).matches();

        if (!validationResult)
            return failureStatus;
        return Status.OK;

    }
    protected String getString(ProcessingClient client) {

        String returnValue;

        int fieldNumber;

        if (client.hasParams()) {
            fieldNumber = Integer.parseInt(client.getValidatorParams().get(FIELDNUMBER_PARAM));
        } else {
            fieldNumber = FIELDNUMBER_DEFUALT;
        }

        int numFields = client.getNumFields();
        if (numFields <= fieldNumber) {
            returnValue = client.getFieldContents(fieldNumber);
        } else {
            // Should never get here, but might as well try and grab some text
            returnValue = client.getFieldContents(numFields - 1);
        }
        return returnValue;
       }
   }
