package com.redhat.installer.framework.testers;

import com.izforge.izpack.installer.ParameteredDataValidator;
import org.junit.After;

/**
 * Created by thauser on 20/07/17.
 */
public class ParameteredDataValidatorTester extends DataValidatorTester {
    public ParameteredDataValidator pdv;

    @After
    public void end() throws Exception{
        pdv = null;
        dv = null;
    }

    /**
     * Expect the value Status.OK from a validateData call
     */
    public void assertStatusOk(){
        dv = pdv;
        super.assertStatusOk();
    }
    /**
     * Used in the jsf validators to pass through
     * warning messages via an adata variable
     */
    public void assertStatusCombinedMsgWarning(){
        dv = pdv;
        super.assertStatusCombinedMsgWarning();
    }

    /**
     * Used to test the auto detected version
     * found by VerifyJsfVersionValidator
     * @param ver
     */
    public void assertVersionMatches(String ver){
        dv = pdv;
        super.assertVersionMatches(ver);
    }

    /**
     * Expect the value Status.ERROR from a validateData call
     */
    public void assertStatusError(){
        dv = pdv;
        super.assertStatusError();
    }

    /**
     * Expect the value Status.SKIP from a validateData call
     */
    public void assertStatusSkip(){
        dv = pdv;
        super.assertStatusSkip();
    }

    /**
     * Expect the value Status.WARNING from a validateData call
     */
    public void assertStatusWarning(){
        dv = pdv;
        super.assertStatusWarning();
    }

    /**
     * Expect the value Status.FAIL from a validateData call
     */
    public void assertStatusFail(){
        dv = pdv;
        super.assertStatusFail();
    }

    /**
     * Expect the given key from the langpack on a DataValidator.getFormattedMessage() call
     *
     * @param key
     */
    public void assertLangpack(String key){
        dv = pdv;
        super.assertLangpack(key);
    }


}
