package com.izforge.izpack.gui.patternfly;

import com.izforge.izpack.gui.ButtonFactory;

import javax.swing.*;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import java.awt.*;
import java.util.Locale;

/**
 * Created by thauser on 4/14/15.
 */
public class PatternflyOptionPaneUI extends BasicOptionPaneUI {

    private static JButton okButton;
    private static JButton cancelButton;
    private static JButton yesButton;
    private static JButton noButton;

    public static ComponentUI createUI(JComponent c) {
        return new PatternflyOptionPaneUI();
    }

    @Override
    protected Object[] getButtons() {
        JButton[] defaultOptions = null;
        if (this.optionPane != null) {
            Object[] options = this.optionPane.getOptions();
            String leftButtonText = null;
            String rightButtonText = null;
            JButton leftButton = null;
            JButton rightButton = null;
            if (options!=null){
                if(options[0] instanceof JButton && options[1] instanceof JButton){
                    leftButton = (JButton) options[0];
                    rightButton = (JButton) options[1];
                } else {
                    leftButtonText = (String) options[0];
                    rightButtonText = (String) options[1];
                }
            }
            int type = this.optionPane.getOptionType();
            Locale l = this.optionPane.getLocale();
            if (type == 0) {
                defaultOptions = new JButton[2];
                defaultOptions[0] = leftButton == null ? getYesButton(leftButtonText, l) : leftButton;
                defaultOptions[1] = rightButton == null? getNoButton(rightButtonText, l) : rightButton;
            } else if (type == 1) {
                defaultOptions = new JButton[3];
                defaultOptions[0] = getYesButton(leftButtonText, l);
                defaultOptions[1] = getNoButton(rightButtonText, l);
                defaultOptions[2] = getCancelButton(l);
            } else if (type == 2) {
                defaultOptions = new JButton[2];
                defaultOptions[0] = leftButton == null ? getOkButton(leftButtonText, l) : leftButton;
                defaultOptions[1] = rightButton == null ? getCancelButton(rightButtonText, l) : rightButton;
            } else {
                defaultOptions = new JButton[1];
                defaultOptions[0] = getOkButton(l);
            }
        }
        return defaultOptions;
    }

    private JButton getYesButton(String text, Locale l) {
        if (text == null){
            return getYesButton(l);
        } else if (yesButton == null || !yesButton.getLocale().equals(l) || !text.equals(yesButton.getText())) {
            // setting the mnemonic to the first character in this case is only ok because there's no way to see the dialog twice in an install.
            yesButton = ButtonFactory.createButton(text , text.charAt(0));
        }
        return yesButton;
    }

    private JButton getYesButton(Locale l) {
        if (yesButton == null || !yesButton.getLocale().equals(l)) {
            yesButton = ButtonFactory.createButton(UIManager.getString("OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l));
        }
        return yesButton;
    }


    private JButton getNoButton(String text, Locale l) {
        if (text == null){
            return getNoButton(l);
        } else if (text != null && noButton == null || !noButton.getLocale().equals(l) || !text.equals(noButton.getText())) {
            noButton = ButtonFactory.createButton(text, text.charAt(0));
        }
        return noButton;
    }

    private JButton getNoButton(Locale l) {
        if (noButton == null || !noButton.getLocale().equals(l)) {
            noButton = ButtonFactory.createButton(UIManager.getString("OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l));
        }
        return noButton;
    }

    private JButton getCancelButton(String text, Locale l) {
        if (text == null){
            return getCancelButton(l);
        } else if (cancelButton == null || !cancelButton.getLocale().equals(l) || !text.equals(cancelButton.getText())){
            cancelButton = ButtonFactory.createButton(text, text.charAt(0));
        }
        return cancelButton;
    }

    private JButton getCancelButton(Locale l) {
        if (cancelButton == null || !cancelButton.getLocale().equals(l)){
            cancelButton = ButtonFactory.createButton(UIManager.getString("OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l));
        }
        return cancelButton;
    }

    private JButton getOkButton(String text, Locale l) {
        if (text == null){
            return getOkButton(l);
        } else if (text != null && okButton == null || !okButton.getLocale().equals(l) || !text.equals(okButton.getText())) {
            okButton = ButtonFactory.createButton(text, text.charAt(0));
        }
        return okButton;
    }

    private JButton getOkButton(Locale l) {
        if (okButton == null || !okButton.getLocale().equals(l)) {
            okButton = ButtonFactory.createButton(UIManager.getString("OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l));
        }
        return okButton;
    }

    @Override
    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        super.addButtonComponents(container, buttons, initialIndex);
        for (int index = 0; index < buttons.length; index++) {
            JButton aButton = (JButton) buttons[index];
            aButton.addActionListener(createButtonActionListener(index));
        }
    }

    private int getMnemonic(String key, Locale l) {
        String value = (String) UIManager.get(key, l);
        if (value == null) {
            return 0;
        } else {
            try {
                return Integer.parseInt(value);
            } catch (NumberFormatException nfe) {
                return 0;
            }
        }
    }
}
