/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.kie.server.springboot.samples;

import org.jbpm.process.instance.event.listeners.VariableGuardProcessEventListener;
import org.kie.internal.identity.IdentityProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KeycloakVariableGuardProcessEventListener extends VariableGuardProcessEventListener {

    public KeycloakVariableGuardProcessEventListener(@Value("${kie.restricted-role}")String requiredRole, IdentityProvider identityProvider) {
        super(requiredRole, identityProvider);
    }

}
