package org.jboss.brmsbpmsuite.patching.client;

import org.jboss.brmsbpmsuite.patching.phase.PatchingPhase;

import java.io.File;
import java.util.List;

public class CommonMainArgs {
    protected static final int SUCCESSFUL_EXIT = 0;
    protected static final int INVALID_ARGS_EXIT = 1;
    protected static final int UNKNOWN_DISTRIBUTION_TYPE_EXIT = 2;

    private File distributionRoot;
    private DistributionType distributionType;
    private List<PatchingPhase> phases;
    private boolean printHelp;
    private int exitStatus;

    protected CommonMainArgs(File distributionRoot, DistributionType distributionType, List<PatchingPhase> phases, boolean printHelp, int exitStatus) {
        this.distributionRoot = distributionRoot;
        this.distributionType = distributionType;
        this.phases = phases;
        this.printHelp = printHelp;
        this.exitStatus = exitStatus;
    }

    public File getDistributionRoot() {
        return distributionRoot;
    }

    public void setDistributionRoot(File distributionRoot) {
        this.distributionRoot = distributionRoot;
    }

    public DistributionType getDistributionType() {
        return distributionType;
    }

    public void setDistributionType(DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public List<PatchingPhase> getPhases() {
        return phases;
    }

    public void setPhases(List<PatchingPhase> phases) {
        this.phases = phases;
    }

    public boolean shouldPrintHelp() {
        return printHelp;
    }

    public void setPrintHelp(boolean printHelp) {
        this.printHelp = printHelp;
    }

    public int getExitStatus() {
        return exitStatus;
    }

    public void setExitStatus(int exitStatus) {
        this.exitStatus = exitStatus;
    }
}
