/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.workbench.df.client.filter;

import org.jboss.errai.databinding.client.api.Bindable;

@Bindable
public class SavedFilter {

    private String key;

    private String name;

    private boolean defaultFilter;

    public SavedFilter() {
    }

    public SavedFilter(final String key,
                       final String name) {
        this.key = key;
        this.name = name;
    }

    public SavedFilter(final String key,
                       final String name,
                       final boolean defaultFilter) {
        this(key, name);
        this.defaultFilter = defaultFilter;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDefaultFilter() {
        return defaultFilter;
    }

    public void setDefaultFilter(boolean defaultFilter) {
        this.defaultFilter = defaultFilter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SavedFilter)) {
            return false;
        }

        SavedFilter that = (SavedFilter) o;

        return getKey().equals(that.getKey());
    }

    @Override
    public int hashCode() {
        return getKey().hashCode();
    }

    @Override
    public String toString() {
        return "SavedFilter{" +
                "key='" + key + '\'' +
                ", name='" + name + '\'' +
                ", defaulFilter=" + defaultFilter +
                '}';
    }
}
