// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerExistsLibpodReader is a Reader for the ContainerExistsLibpod structure.
type ContainerExistsLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerExistsLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewContainerExistsLibpodNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerExistsLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerExistsLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerExistsLibpodNoContent creates a ContainerExistsLibpodNoContent with default headers values
func NewContainerExistsLibpodNoContent() *ContainerExistsLibpodNoContent {
	return &ContainerExistsLibpodNoContent{}
}

/*
ContainerExistsLibpodNoContent describes a response with status code 204, with default header values.

container exists
*/
type ContainerExistsLibpodNoContent struct {
}

// IsSuccess returns true when this container exists libpod no content response has a 2xx status code
func (o *ContainerExistsLibpodNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container exists libpod no content response has a 3xx status code
func (o *ContainerExistsLibpodNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container exists libpod no content response has a 4xx status code
func (o *ContainerExistsLibpodNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this container exists libpod no content response has a 5xx status code
func (o *ContainerExistsLibpodNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this container exists libpod no content response a status code equal to that given
func (o *ContainerExistsLibpodNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *ContainerExistsLibpodNoContent) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/exists][%d] containerExistsLibpodNoContent ", 204)
}

func (o *ContainerExistsLibpodNoContent) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/exists][%d] containerExistsLibpodNoContent ", 204)
}

func (o *ContainerExistsLibpodNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerExistsLibpodNotFound creates a ContainerExistsLibpodNotFound with default headers values
func NewContainerExistsLibpodNotFound() *ContainerExistsLibpodNotFound {
	return &ContainerExistsLibpodNotFound{}
}

/*
ContainerExistsLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerExistsLibpodNotFound struct {
	Payload *ContainerExistsLibpodNotFoundBody
}

// IsSuccess returns true when this container exists libpod not found response has a 2xx status code
func (o *ContainerExistsLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container exists libpod not found response has a 3xx status code
func (o *ContainerExistsLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container exists libpod not found response has a 4xx status code
func (o *ContainerExistsLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container exists libpod not found response has a 5xx status code
func (o *ContainerExistsLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container exists libpod not found response a status code equal to that given
func (o *ContainerExistsLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerExistsLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/exists][%d] containerExistsLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerExistsLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/exists][%d] containerExistsLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerExistsLibpodNotFound) GetPayload() *ContainerExistsLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerExistsLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerExistsLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerExistsLibpodInternalServerError creates a ContainerExistsLibpodInternalServerError with default headers values
func NewContainerExistsLibpodInternalServerError() *ContainerExistsLibpodInternalServerError {
	return &ContainerExistsLibpodInternalServerError{}
}

/*
ContainerExistsLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerExistsLibpodInternalServerError struct {
	Payload *ContainerExistsLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container exists libpod internal server error response has a 2xx status code
func (o *ContainerExistsLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container exists libpod internal server error response has a 3xx status code
func (o *ContainerExistsLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container exists libpod internal server error response has a 4xx status code
func (o *ContainerExistsLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container exists libpod internal server error response has a 5xx status code
func (o *ContainerExistsLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container exists libpod internal server error response a status code equal to that given
func (o *ContainerExistsLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerExistsLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/exists][%d] containerExistsLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerExistsLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/exists][%d] containerExistsLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerExistsLibpodInternalServerError) GetPayload() *ContainerExistsLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerExistsLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerExistsLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerExistsLibpodInternalServerErrorBody container exists libpod internal server error body
swagger:model ContainerExistsLibpodInternalServerErrorBody
*/
type ContainerExistsLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container exists libpod internal server error body
func (o *ContainerExistsLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container exists libpod internal server error body based on context it is used
func (o *ContainerExistsLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerExistsLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerExistsLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerExistsLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerExistsLibpodNotFoundBody container exists libpod not found body
swagger:model ContainerExistsLibpodNotFoundBody
*/
type ContainerExistsLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container exists libpod not found body
func (o *ContainerExistsLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container exists libpod not found body based on context it is used
func (o *ContainerExistsLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerExistsLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerExistsLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerExistsLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
