// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerPauseLibpodReader is a Reader for the ContainerPauseLibpod structure.
type ContainerPauseLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerPauseLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewContainerPauseLibpodNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerPauseLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerPauseLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerPauseLibpodNoContent creates a ContainerPauseLibpodNoContent with default headers values
func NewContainerPauseLibpodNoContent() *ContainerPauseLibpodNoContent {
	return &ContainerPauseLibpodNoContent{}
}

/*
ContainerPauseLibpodNoContent describes a response with status code 204, with default header values.

no error
*/
type ContainerPauseLibpodNoContent struct {
}

// IsSuccess returns true when this container pause libpod no content response has a 2xx status code
func (o *ContainerPauseLibpodNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container pause libpod no content response has a 3xx status code
func (o *ContainerPauseLibpodNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container pause libpod no content response has a 4xx status code
func (o *ContainerPauseLibpodNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this container pause libpod no content response has a 5xx status code
func (o *ContainerPauseLibpodNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this container pause libpod no content response a status code equal to that given
func (o *ContainerPauseLibpodNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *ContainerPauseLibpodNoContent) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/pause][%d] containerPauseLibpodNoContent ", 204)
}

func (o *ContainerPauseLibpodNoContent) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/pause][%d] containerPauseLibpodNoContent ", 204)
}

func (o *ContainerPauseLibpodNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerPauseLibpodNotFound creates a ContainerPauseLibpodNotFound with default headers values
func NewContainerPauseLibpodNotFound() *ContainerPauseLibpodNotFound {
	return &ContainerPauseLibpodNotFound{}
}

/*
ContainerPauseLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerPauseLibpodNotFound struct {
	Payload *ContainerPauseLibpodNotFoundBody
}

// IsSuccess returns true when this container pause libpod not found response has a 2xx status code
func (o *ContainerPauseLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container pause libpod not found response has a 3xx status code
func (o *ContainerPauseLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container pause libpod not found response has a 4xx status code
func (o *ContainerPauseLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container pause libpod not found response has a 5xx status code
func (o *ContainerPauseLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container pause libpod not found response a status code equal to that given
func (o *ContainerPauseLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerPauseLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/pause][%d] containerPauseLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerPauseLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/pause][%d] containerPauseLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerPauseLibpodNotFound) GetPayload() *ContainerPauseLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerPauseLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerPauseLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerPauseLibpodInternalServerError creates a ContainerPauseLibpodInternalServerError with default headers values
func NewContainerPauseLibpodInternalServerError() *ContainerPauseLibpodInternalServerError {
	return &ContainerPauseLibpodInternalServerError{}
}

/*
ContainerPauseLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerPauseLibpodInternalServerError struct {
	Payload *ContainerPauseLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container pause libpod internal server error response has a 2xx status code
func (o *ContainerPauseLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container pause libpod internal server error response has a 3xx status code
func (o *ContainerPauseLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container pause libpod internal server error response has a 4xx status code
func (o *ContainerPauseLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container pause libpod internal server error response has a 5xx status code
func (o *ContainerPauseLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container pause libpod internal server error response a status code equal to that given
func (o *ContainerPauseLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerPauseLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/pause][%d] containerPauseLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerPauseLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/pause][%d] containerPauseLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerPauseLibpodInternalServerError) GetPayload() *ContainerPauseLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerPauseLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerPauseLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerPauseLibpodInternalServerErrorBody container pause libpod internal server error body
swagger:model ContainerPauseLibpodInternalServerErrorBody
*/
type ContainerPauseLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container pause libpod internal server error body
func (o *ContainerPauseLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container pause libpod internal server error body based on context it is used
func (o *ContainerPauseLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerPauseLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerPauseLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerPauseLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerPauseLibpodNotFoundBody container pause libpod not found body
swagger:model ContainerPauseLibpodNotFoundBody
*/
type ContainerPauseLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container pause libpod not found body
func (o *ContainerPauseLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container pause libpod not found body based on context it is used
func (o *ContainerPauseLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerPauseLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerPauseLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerPauseLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
