// Code generated by go-swagger; DO NOT EDIT.

package system

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// SystemVersionLibpodReader is a Reader for the SystemVersionLibpod structure.
type SystemVersionLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SystemVersionLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSystemVersionLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSystemVersionLibpodOK creates a SystemVersionLibpodOK with default headers values
func NewSystemVersionLibpodOK() *SystemVersionLibpodOK {
	return &SystemVersionLibpodOK{}
}

/*
SystemVersionLibpodOK describes a response with status code 200, with default header values.

Version
*/
type SystemVersionLibpodOK struct {
	Payload *SystemVersionLibpodOKBody
}

// IsSuccess returns true when this system version libpod o k response has a 2xx status code
func (o *SystemVersionLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this system version libpod o k response has a 3xx status code
func (o *SystemVersionLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system version libpod o k response has a 4xx status code
func (o *SystemVersionLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this system version libpod o k response has a 5xx status code
func (o *SystemVersionLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this system version libpod o k response a status code equal to that given
func (o *SystemVersionLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *SystemVersionLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/version][%d] systemVersionLibpodOK  %+v", 200, o.Payload)
}

func (o *SystemVersionLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/version][%d] systemVersionLibpodOK  %+v", 200, o.Payload)
}

func (o *SystemVersionLibpodOK) GetPayload() *SystemVersionLibpodOKBody {
	return o.Payload
}

func (o *SystemVersionLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemVersionLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SystemVersionLibpodOKBody system version libpod o k body
swagger:model SystemVersionLibpodOKBody
*/
type SystemVersionLibpodOKBody struct {

	// API version
	APIVersion string `json:"ApiVersion,omitempty"`

	// arch
	Arch string `json:"Arch,omitempty"`

	// build time
	BuildTime string `json:"BuildTime,omitempty"`

	// components
	Components []*models.ComponentVersion `json:"Components"`

	// experimental
	Experimental bool `json:"Experimental,omitempty"`

	// git commit
	GitCommit string `json:"GitCommit,omitempty"`

	// go version
	GoVersion string `json:"GoVersion,omitempty"`

	// kernel version
	KernelVersion string `json:"KernelVersion,omitempty"`

	// min API version
	MinAPIVersion string `json:"MinAPIVersion,omitempty"`

	// os
	Os string `json:"Os,omitempty"`

	// platform
	Platform interface{} `json:"Platform,omitempty"`

	// version
	Version string `json:"Version,omitempty"`
}

// Validate validates this system version libpod o k body
func (o *SystemVersionLibpodOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComponents(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SystemVersionLibpodOKBody) validateComponents(formats strfmt.Registry) error {
	if swag.IsZero(o.Components) { // not required
		return nil
	}

	for i := 0; i < len(o.Components); i++ {
		if swag.IsZero(o.Components[i]) { // not required
			continue
		}

		if o.Components[i] != nil {
			if err := o.Components[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemVersionLibpodOK" + "." + "Components" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemVersionLibpodOK" + "." + "Components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this system version libpod o k body based on the context it is used
func (o *SystemVersionLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateComponents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SystemVersionLibpodOKBody) contextValidateComponents(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Components); i++ {

		if o.Components[i] != nil {
			if err := o.Components[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemVersionLibpodOK" + "." + "Components" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemVersionLibpodOK" + "." + "Components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SystemVersionLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemVersionLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res SystemVersionLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
