/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	v2alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v2alpha1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// ListenerLister helps list Listeners.
// All objects returned here must be treated as read-only.
type ListenerLister interface {
	// List lists all Listeners in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.Listener, err error)
	// Listeners returns an object that can list and get Listeners.
	Listeners(namespace string) ListenerNamespaceLister
	ListenerListerExpansion
}

// listenerLister implements the ListenerLister interface.
type listenerLister struct {
	listers.ResourceIndexer[*v2alpha1.Listener]
}

// NewListenerLister returns a new ListenerLister.
func NewListenerLister(indexer cache.Indexer) ListenerLister {
	return &listenerLister{listers.New[*v2alpha1.Listener](indexer, v2alpha1.Resource("listener"))}
}

// Listeners returns an object that can list and get Listeners.
func (s *listenerLister) Listeners(namespace string) ListenerNamespaceLister {
	return listenerNamespaceLister{listers.NewNamespaced[*v2alpha1.Listener](s.ResourceIndexer, namespace)}
}

// ListenerNamespaceLister helps list and get Listeners.
// All objects returned here must be treated as read-only.
type ListenerNamespaceLister interface {
	// List lists all Listeners in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.Listener, err error)
	// Get retrieves the Listener from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2alpha1.Listener, error)
	ListenerNamespaceListerExpansion
}

// listenerNamespaceLister implements the ListenerNamespaceLister
// interface.
type listenerNamespaceLister struct {
	listers.ResourceIndexer[*v2alpha1.Listener]
}
