// Code generated by go-swagger; DO NOT EDIT.

package images_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewImageDeleteParams creates a new ImageDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImageDeleteParams() *ImageDeleteParams {
	return &ImageDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImageDeleteParamsWithTimeout creates a new ImageDeleteParams object
// with the ability to set a timeout on a request.
func NewImageDeleteParamsWithTimeout(timeout time.Duration) *ImageDeleteParams {
	return &ImageDeleteParams{
		timeout: timeout,
	}
}

// NewImageDeleteParamsWithContext creates a new ImageDeleteParams object
// with the ability to set a context for a request.
func NewImageDeleteParamsWithContext(ctx context.Context) *ImageDeleteParams {
	return &ImageDeleteParams{
		Context: ctx,
	}
}

// NewImageDeleteParamsWithHTTPClient creates a new ImageDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewImageDeleteParamsWithHTTPClient(client *http.Client) *ImageDeleteParams {
	return &ImageDeleteParams{
		HTTPClient: client,
	}
}

/*
ImageDeleteParams contains all the parameters to send to the API endpoint

	for the image delete operation.

	Typically these are written to a http.Request.
*/
type ImageDeleteParams struct {

	/* Force.

	   remove the image even if used by containers or has other tags
	*/
	Force *bool

	/* Name.

	   name or ID of image to delete
	*/
	Name string

	/* Noprune.

	   not supported. will be logged as an invalid parameter if enabled
	*/
	Noprune *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageDeleteParams) WithDefaults() *ImageDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the image delete params
func (o *ImageDeleteParams) WithTimeout(timeout time.Duration) *ImageDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image delete params
func (o *ImageDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image delete params
func (o *ImageDeleteParams) WithContext(ctx context.Context) *ImageDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image delete params
func (o *ImageDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image delete params
func (o *ImageDeleteParams) WithHTTPClient(client *http.Client) *ImageDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image delete params
func (o *ImageDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithForce adds the force to the image delete params
func (o *ImageDeleteParams) WithForce(force *bool) *ImageDeleteParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the image delete params
func (o *ImageDeleteParams) SetForce(force *bool) {
	o.Force = force
}

// WithName adds the name to the image delete params
func (o *ImageDeleteParams) WithName(name string) *ImageDeleteParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the image delete params
func (o *ImageDeleteParams) SetName(name string) {
	o.Name = name
}

// WithNoprune adds the noprune to the image delete params
func (o *ImageDeleteParams) WithNoprune(noprune *bool) *ImageDeleteParams {
	o.SetNoprune(noprune)
	return o
}

// SetNoprune adds the noprune to the image delete params
func (o *ImageDeleteParams) SetNoprune(noprune *bool) {
	o.Noprune = noprune
}

// WriteToRequest writes these params to a swagger request
func (o *ImageDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Noprune != nil {

		// query param noprune
		var qrNoprune bool

		if o.Noprune != nil {
			qrNoprune = *o.Noprune
		}
		qNoprune := swag.FormatBool(qrNoprune)
		if qNoprune != "" {

			if err := r.SetQueryParam("noprune", qNoprune); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
