// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NetworkResource NetworkResource is the body of the "get network" http response message
//
// swagger:model NetworkResource
type NetworkResource struct {

	// attachable
	Attachable bool `json:"Attachable,omitempty"`

	// config from
	ConfigFrom *ConfigReference `json:"ConfigFrom,omitempty"`

	// config only
	ConfigOnly bool `json:"ConfigOnly,omitempty"`

	// containers
	Containers map[string]EndpointResource `json:"Containers,omitempty"`

	// created
	// Format: date-time
	Created strfmt.DateTime `json:"Created,omitempty"`

	// driver
	Driver string `json:"Driver,omitempty"`

	// enable IPv6
	EnableIPV6 bool `json:"EnableIPv6,omitempty"`

	// ID
	ID string `json:"Id,omitempty"`

	// IP a m
	IPAM *IPAM `json:"IPAM,omitempty"`

	// ingress
	Ingress bool `json:"Ingress,omitempty"`

	// internal
	Internal bool `json:"Internal,omitempty"`

	// labels
	Labels map[string]string `json:"Labels,omitempty"`

	// name
	Name string `json:"Name,omitempty"`

	// options
	Options map[string]string `json:"Options,omitempty"`

	// peers
	Peers []*PeerInfo `json:"Peers"`

	// scope
	Scope string `json:"Scope,omitempty"`

	// services
	Services map[string]ServiceInfo `json:"Services,omitempty"`
}

// Validate validates this network resource
func (m *NetworkResource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConfigFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateContainers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreated(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPAM(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServices(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetworkResource) validateConfigFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfigFrom) { // not required
		return nil
	}

	if m.ConfigFrom != nil {
		if err := m.ConfigFrom.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ConfigFrom")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ConfigFrom")
			}
			return err
		}
	}

	return nil
}

func (m *NetworkResource) validateContainers(formats strfmt.Registry) error {
	if swag.IsZero(m.Containers) { // not required
		return nil
	}

	for k := range m.Containers {

		if err := validate.Required("Containers"+"."+k, "body", m.Containers[k]); err != nil {
			return err
		}
		if val, ok := m.Containers[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Containers" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Containers" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *NetworkResource) validateCreated(formats strfmt.Registry) error {
	if swag.IsZero(m.Created) { // not required
		return nil
	}

	if err := validate.FormatOf("Created", "body", "date-time", m.Created.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *NetworkResource) validateIPAM(formats strfmt.Registry) error {
	if swag.IsZero(m.IPAM) { // not required
		return nil
	}

	if m.IPAM != nil {
		if err := m.IPAM.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("IPAM")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("IPAM")
			}
			return err
		}
	}

	return nil
}

func (m *NetworkResource) validatePeers(formats strfmt.Registry) error {
	if swag.IsZero(m.Peers) { // not required
		return nil
	}

	for i := 0; i < len(m.Peers); i++ {
		if swag.IsZero(m.Peers[i]) { // not required
			continue
		}

		if m.Peers[i] != nil {
			if err := m.Peers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Peers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Peers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NetworkResource) validateServices(formats strfmt.Registry) error {
	if swag.IsZero(m.Services) { // not required
		return nil
	}

	for k := range m.Services {

		if err := validate.Required("Services"+"."+k, "body", m.Services[k]); err != nil {
			return err
		}
		if val, ok := m.Services[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Services" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Services" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this network resource based on the context it is used
func (m *NetworkResource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfigFrom(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateContainers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPAM(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetworkResource) contextValidateConfigFrom(ctx context.Context, formats strfmt.Registry) error {

	if m.ConfigFrom != nil {
		if err := m.ConfigFrom.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ConfigFrom")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ConfigFrom")
			}
			return err
		}
	}

	return nil
}

func (m *NetworkResource) contextValidateContainers(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.Containers {

		if val, ok := m.Containers[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *NetworkResource) contextValidateIPAM(ctx context.Context, formats strfmt.Registry) error {

	if m.IPAM != nil {
		if err := m.IPAM.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("IPAM")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("IPAM")
			}
			return err
		}
	}

	return nil
}

func (m *NetworkResource) contextValidatePeers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Peers); i++ {

		if m.Peers[i] != nil {
			if err := m.Peers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Peers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Peers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NetworkResource) contextValidateServices(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.Services {

		if val, ok := m.Services[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NetworkResource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NetworkResource) UnmarshalBinary(b []byte) error {
	var res NetworkResource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
