// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Schema2HealthConfig Schema2HealthConfig is a HealthConfig, which holds configuration settings
// for the HEALTHCHECK feature, from docker/docker/api/types/container.
//
// swagger:model Schema2HealthConfig
type Schema2HealthConfig struct {

	// interval
	Interval Duration `json:"Interval,omitempty"`

	// Retries is the number of consecutive failures needed to consider a container as unhealthy.
	// Zero means inherit.
	Retries int64 `json:"Retries,omitempty"`

	// start period
	StartPeriod Duration `json:"StartPeriod,omitempty"`

	// Test is the test to perform to check that the container is healthy.
	// An empty slice means to inherit the default.
	// The options are:
	// {} : inherit healthcheck
	// {"NONE"} : disable healthcheck
	// {"CMD", args...} : exec arguments directly
	// {"CMD-SHELL", command} : run command with system's default shell
	Test []string `json:"Test"`

	// timeout
	Timeout Duration `json:"Timeout,omitempty"`
}

// Validate validates this schema2 health config
func (m *Schema2HealthConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateInterval(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartPeriod(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimeout(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Schema2HealthConfig) validateInterval(formats strfmt.Registry) error {
	if swag.IsZero(m.Interval) { // not required
		return nil
	}

	if err := m.Interval.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Interval")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Interval")
		}
		return err
	}

	return nil
}

func (m *Schema2HealthConfig) validateStartPeriod(formats strfmt.Registry) error {
	if swag.IsZero(m.StartPeriod) { // not required
		return nil
	}

	if err := m.StartPeriod.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("StartPeriod")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("StartPeriod")
		}
		return err
	}

	return nil
}

func (m *Schema2HealthConfig) validateTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.Timeout) { // not required
		return nil
	}

	if err := m.Timeout.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Timeout")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Timeout")
		}
		return err
	}

	return nil
}

// ContextValidate validate this schema2 health config based on the context it is used
func (m *Schema2HealthConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateInterval(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartPeriod(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimeout(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Schema2HealthConfig) contextValidateInterval(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Interval.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Interval")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Interval")
		}
		return err
	}

	return nil
}

func (m *Schema2HealthConfig) contextValidateStartPeriod(ctx context.Context, formats strfmt.Registry) error {

	if err := m.StartPeriod.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("StartPeriod")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("StartPeriod")
		}
		return err
	}

	return nil
}

func (m *Schema2HealthConfig) contextValidateTimeout(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Timeout.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Timeout")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Timeout")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Schema2HealthConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Schema2HealthConfig) UnmarshalBinary(b []byte) error {
	var res Schema2HealthConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
