// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewPutContainerArchiveParams creates a new PutContainerArchiveParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPutContainerArchiveParams() *PutContainerArchiveParams {
	return &PutContainerArchiveParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPutContainerArchiveParamsWithTimeout creates a new PutContainerArchiveParams object
// with the ability to set a timeout on a request.
func NewPutContainerArchiveParamsWithTimeout(timeout time.Duration) *PutContainerArchiveParams {
	return &PutContainerArchiveParams{
		timeout: timeout,
	}
}

// NewPutContainerArchiveParamsWithContext creates a new PutContainerArchiveParams object
// with the ability to set a context for a request.
func NewPutContainerArchiveParamsWithContext(ctx context.Context) *PutContainerArchiveParams {
	return &PutContainerArchiveParams{
		Context: ctx,
	}
}

// NewPutContainerArchiveParamsWithHTTPClient creates a new PutContainerArchiveParams object
// with the ability to set a custom HTTPClient for a request.
func NewPutContainerArchiveParamsWithHTTPClient(client *http.Client) *PutContainerArchiveParams {
	return &PutContainerArchiveParams{
		HTTPClient: client,
	}
}

/*
PutContainerArchiveParams contains all the parameters to send to the API endpoint

	for the put container archive operation.

	Typically these are written to a http.Request.
*/
type PutContainerArchiveParams struct {

	/* CopyUIDGID.

	   copy UID/GID maps to the dest file or di (1 or true)
	*/
	CopyUIDGID *string

	/* Name.

	   container name or id
	*/
	Name string

	/* NoOverwriteDirNonDir.

	   if unpacking the given content would cause an existing directory to be replaced with a non-directory and vice versa (1 or true)
	*/
	NoOverwriteDirNonDir *string

	/* Path.

	   Path to a directory in the container to extract
	*/
	Path string

	/* Request.

	   tarfile of files to copy into the container
	*/
	Request string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the put container archive params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutContainerArchiveParams) WithDefaults() *PutContainerArchiveParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the put container archive params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutContainerArchiveParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the put container archive params
func (o *PutContainerArchiveParams) WithTimeout(timeout time.Duration) *PutContainerArchiveParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the put container archive params
func (o *PutContainerArchiveParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the put container archive params
func (o *PutContainerArchiveParams) WithContext(ctx context.Context) *PutContainerArchiveParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the put container archive params
func (o *PutContainerArchiveParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the put container archive params
func (o *PutContainerArchiveParams) WithHTTPClient(client *http.Client) *PutContainerArchiveParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the put container archive params
func (o *PutContainerArchiveParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCopyUIDGID adds the copyUIDGID to the put container archive params
func (o *PutContainerArchiveParams) WithCopyUIDGID(copyUIDGID *string) *PutContainerArchiveParams {
	o.SetCopyUIDGID(copyUIDGID)
	return o
}

// SetCopyUIDGID adds the copyUidGId to the put container archive params
func (o *PutContainerArchiveParams) SetCopyUIDGID(copyUIDGID *string) {
	o.CopyUIDGID = copyUIDGID
}

// WithName adds the name to the put container archive params
func (o *PutContainerArchiveParams) WithName(name string) *PutContainerArchiveParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the put container archive params
func (o *PutContainerArchiveParams) SetName(name string) {
	o.Name = name
}

// WithNoOverwriteDirNonDir adds the noOverwriteDirNonDir to the put container archive params
func (o *PutContainerArchiveParams) WithNoOverwriteDirNonDir(noOverwriteDirNonDir *string) *PutContainerArchiveParams {
	o.SetNoOverwriteDirNonDir(noOverwriteDirNonDir)
	return o
}

// SetNoOverwriteDirNonDir adds the noOverwriteDirNonDir to the put container archive params
func (o *PutContainerArchiveParams) SetNoOverwriteDirNonDir(noOverwriteDirNonDir *string) {
	o.NoOverwriteDirNonDir = noOverwriteDirNonDir
}

// WithPath adds the path to the put container archive params
func (o *PutContainerArchiveParams) WithPath(path string) *PutContainerArchiveParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the put container archive params
func (o *PutContainerArchiveParams) SetPath(path string) {
	o.Path = path
}

// WithRequest adds the request to the put container archive params
func (o *PutContainerArchiveParams) WithRequest(request string) *PutContainerArchiveParams {
	o.SetRequest(request)
	return o
}

// SetRequest adds the request to the put container archive params
func (o *PutContainerArchiveParams) SetRequest(request string) {
	o.Request = request
}

// WriteToRequest writes these params to a swagger request
func (o *PutContainerArchiveParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CopyUIDGID != nil {

		// query param copyUIDGID
		var qrCopyUIDGID string

		if o.CopyUIDGID != nil {
			qrCopyUIDGID = *o.CopyUIDGID
		}
		qCopyUIDGID := qrCopyUIDGID
		if qCopyUIDGID != "" {

			if err := r.SetQueryParam("copyUIDGID", qCopyUIDGID); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.NoOverwriteDirNonDir != nil {

		// query param noOverwriteDirNonDir
		var qrNoOverwriteDirNonDir string

		if o.NoOverwriteDirNonDir != nil {
			qrNoOverwriteDirNonDir = *o.NoOverwriteDirNonDir
		}
		qNoOverwriteDirNonDir := qrNoOverwriteDirNonDir
		if qNoOverwriteDirNonDir != "" {

			if err := r.SetQueryParam("noOverwriteDirNonDir", qNoOverwriteDirNonDir); err != nil {
				return err
			}
		}
	}

	// query param path
	qrPath := o.Path
	qPath := qrPath
	if qPath != "" {

		if err := r.SetQueryParam("path", qPath); err != nil {
			return err
		}
	}
	if err := r.SetBodyParam(o.Request); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
