// Code generated by go-swagger; DO NOT EDIT.

package images_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageTagReader is a Reader for the ImageTag structure.
type ImageTagReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageTagReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewImageTagCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewImageTagBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewImageTagNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewImageTagConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageTagInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageTagCreated creates a ImageTagCreated with default headers values
func NewImageTagCreated() *ImageTagCreated {
	return &ImageTagCreated{}
}

/*
ImageTagCreated describes a response with status code 201, with default header values.

no error
*/
type ImageTagCreated struct {
}

// IsSuccess returns true when this image tag created response has a 2xx status code
func (o *ImageTagCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image tag created response has a 3xx status code
func (o *ImageTagCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image tag created response has a 4xx status code
func (o *ImageTagCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this image tag created response has a 5xx status code
func (o *ImageTagCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this image tag created response a status code equal to that given
func (o *ImageTagCreated) IsCode(code int) bool {
	return code == 201
}

func (o *ImageTagCreated) Error() string {
	return fmt.Sprintf("[POST /images/{name}/tag][%d] imageTagCreated ", 201)
}

func (o *ImageTagCreated) String() string {
	return fmt.Sprintf("[POST /images/{name}/tag][%d] imageTagCreated ", 201)
}

func (o *ImageTagCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewImageTagBadRequest creates a ImageTagBadRequest with default headers values
func NewImageTagBadRequest() *ImageTagBadRequest {
	return &ImageTagBadRequest{}
}

/*
ImageTagBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type ImageTagBadRequest struct {
	Payload *ImageTagBadRequestBody
}

// IsSuccess returns true when this image tag bad request response has a 2xx status code
func (o *ImageTagBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image tag bad request response has a 3xx status code
func (o *ImageTagBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image tag bad request response has a 4xx status code
func (o *ImageTagBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this image tag bad request response has a 5xx status code
func (o *ImageTagBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this image tag bad request response a status code equal to that given
func (o *ImageTagBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *ImageTagBadRequest) Error() string {
	return fmt.Sprintf("[POST /images/{name}/tag][%d] imageTagBadRequest  %+v", 400, o.Payload)
}

func (o *ImageTagBadRequest) String() string {
	return fmt.Sprintf("[POST /images/{name}/tag][%d] imageTagBadRequest  %+v", 400, o.Payload)
}

func (o *ImageTagBadRequest) GetPayload() *ImageTagBadRequestBody {
	return o.Payload
}

func (o *ImageTagBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageTagBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageTagNotFound creates a ImageTagNotFound with default headers values
func NewImageTagNotFound() *ImageTagNotFound {
	return &ImageTagNotFound{}
}

/*
ImageTagNotFound describes a response with status code 404, with default header values.

No such image
*/
type ImageTagNotFound struct {
	Payload *ImageTagNotFoundBody
}

// IsSuccess returns true when this image tag not found response has a 2xx status code
func (o *ImageTagNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image tag not found response has a 3xx status code
func (o *ImageTagNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image tag not found response has a 4xx status code
func (o *ImageTagNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this image tag not found response has a 5xx status code
func (o *ImageTagNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this image tag not found response a status code equal to that given
func (o *ImageTagNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ImageTagNotFound) Error() string {
	return fmt.Sprintf("[POST /images/{name}/tag][%d] imageTagNotFound  %+v", 404, o.Payload)
}

func (o *ImageTagNotFound) String() string {
	return fmt.Sprintf("[POST /images/{name}/tag][%d] imageTagNotFound  %+v", 404, o.Payload)
}

func (o *ImageTagNotFound) GetPayload() *ImageTagNotFoundBody {
	return o.Payload
}

func (o *ImageTagNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageTagNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageTagConflict creates a ImageTagConflict with default headers values
func NewImageTagConflict() *ImageTagConflict {
	return &ImageTagConflict{}
}

/*
ImageTagConflict describes a response with status code 409, with default header values.

Conflict error in operation
*/
type ImageTagConflict struct {
	Payload *ImageTagConflictBody
}

// IsSuccess returns true when this image tag conflict response has a 2xx status code
func (o *ImageTagConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image tag conflict response has a 3xx status code
func (o *ImageTagConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image tag conflict response has a 4xx status code
func (o *ImageTagConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this image tag conflict response has a 5xx status code
func (o *ImageTagConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this image tag conflict response a status code equal to that given
func (o *ImageTagConflict) IsCode(code int) bool {
	return code == 409
}

func (o *ImageTagConflict) Error() string {
	return fmt.Sprintf("[POST /images/{name}/tag][%d] imageTagConflict  %+v", 409, o.Payload)
}

func (o *ImageTagConflict) String() string {
	return fmt.Sprintf("[POST /images/{name}/tag][%d] imageTagConflict  %+v", 409, o.Payload)
}

func (o *ImageTagConflict) GetPayload() *ImageTagConflictBody {
	return o.Payload
}

func (o *ImageTagConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageTagConflictBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageTagInternalServerError creates a ImageTagInternalServerError with default headers values
func NewImageTagInternalServerError() *ImageTagInternalServerError {
	return &ImageTagInternalServerError{}
}

/*
ImageTagInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageTagInternalServerError struct {
	Payload *ImageTagInternalServerErrorBody
}

// IsSuccess returns true when this image tag internal server error response has a 2xx status code
func (o *ImageTagInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image tag internal server error response has a 3xx status code
func (o *ImageTagInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image tag internal server error response has a 4xx status code
func (o *ImageTagInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image tag internal server error response has a 5xx status code
func (o *ImageTagInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image tag internal server error response a status code equal to that given
func (o *ImageTagInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageTagInternalServerError) Error() string {
	return fmt.Sprintf("[POST /images/{name}/tag][%d] imageTagInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageTagInternalServerError) String() string {
	return fmt.Sprintf("[POST /images/{name}/tag][%d] imageTagInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageTagInternalServerError) GetPayload() *ImageTagInternalServerErrorBody {
	return o.Payload
}

func (o *ImageTagInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageTagInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageTagBadRequestBody image tag bad request body
swagger:model ImageTagBadRequestBody
*/
type ImageTagBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image tag bad request body
func (o *ImageTagBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image tag bad request body based on context it is used
func (o *ImageTagBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageTagBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageTagBadRequestBody) UnmarshalBinary(b []byte) error {
	var res ImageTagBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageTagConflictBody image tag conflict body
swagger:model ImageTagConflictBody
*/
type ImageTagConflictBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image tag conflict body
func (o *ImageTagConflictBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image tag conflict body based on context it is used
func (o *ImageTagConflictBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageTagConflictBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageTagConflictBody) UnmarshalBinary(b []byte) error {
	var res ImageTagConflictBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageTagInternalServerErrorBody image tag internal server error body
swagger:model ImageTagInternalServerErrorBody
*/
type ImageTagInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image tag internal server error body
func (o *ImageTagInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image tag internal server error body based on context it is used
func (o *ImageTagInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageTagInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageTagInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageTagInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageTagNotFoundBody image tag not found body
swagger:model ImageTagNotFoundBody
*/
type ImageTagNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image tag not found body
func (o *ImageTagNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image tag not found body based on context it is used
func (o *ImageTagNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageTagNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageTagNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ImageTagNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
