/*
Copyright 2021 The Skupper Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v2alpha1 "github.com/skupperproject/skupper/pkg/apis/skupper/v2alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeAccessGrants implements AccessGrantInterface
type FakeAccessGrants struct {
	Fake *FakeSkupperV2alpha1
	ns   string
}

var accessgrantsResource = v2alpha1.SchemeGroupVersion.WithResource("accessgrants")

var accessgrantsKind = v2alpha1.SchemeGroupVersion.WithKind("AccessGrant")

// Get takes name of the accessGrant, and returns the corresponding accessGrant object, and an error if there is any.
func (c *FakeAccessGrants) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2alpha1.AccessGrant, err error) {
	emptyResult := &v2alpha1.AccessGrant{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(accessgrantsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.AccessGrant), err
}

// List takes label and field selectors, and returns the list of AccessGrants that match those selectors.
func (c *FakeAccessGrants) List(ctx context.Context, opts v1.ListOptions) (result *v2alpha1.AccessGrantList, err error) {
	emptyResult := &v2alpha1.AccessGrantList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(accessgrantsResource, accessgrantsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v2alpha1.AccessGrantList{ListMeta: obj.(*v2alpha1.AccessGrantList).ListMeta}
	for _, item := range obj.(*v2alpha1.AccessGrantList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested accessGrants.
func (c *FakeAccessGrants) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(accessgrantsResource, c.ns, opts))

}

// Create takes the representation of a accessGrant and creates it.  Returns the server's representation of the accessGrant, and an error, if there is any.
func (c *FakeAccessGrants) Create(ctx context.Context, accessGrant *v2alpha1.AccessGrant, opts v1.CreateOptions) (result *v2alpha1.AccessGrant, err error) {
	emptyResult := &v2alpha1.AccessGrant{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(accessgrantsResource, c.ns, accessGrant, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.AccessGrant), err
}

// Update takes the representation of a accessGrant and updates it. Returns the server's representation of the accessGrant, and an error, if there is any.
func (c *FakeAccessGrants) Update(ctx context.Context, accessGrant *v2alpha1.AccessGrant, opts v1.UpdateOptions) (result *v2alpha1.AccessGrant, err error) {
	emptyResult := &v2alpha1.AccessGrant{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(accessgrantsResource, c.ns, accessGrant, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.AccessGrant), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeAccessGrants) UpdateStatus(ctx context.Context, accessGrant *v2alpha1.AccessGrant, opts v1.UpdateOptions) (result *v2alpha1.AccessGrant, err error) {
	emptyResult := &v2alpha1.AccessGrant{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(accessgrantsResource, "status", c.ns, accessGrant, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.AccessGrant), err
}

// Delete takes name of the accessGrant and deletes it. Returns an error if one occurs.
func (c *FakeAccessGrants) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(accessgrantsResource, c.ns, name, opts), &v2alpha1.AccessGrant{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeAccessGrants) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(accessgrantsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v2alpha1.AccessGrantList{})
	return err
}

// Patch applies the patch and returns the patched accessGrant.
func (c *FakeAccessGrants) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.AccessGrant, err error) {
	emptyResult := &v2alpha1.AccessGrant{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(accessgrantsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.AccessGrant), err
}
