// Code generated by go-swagger; DO NOT EDIT.

package volumes_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// VolumeDeleteReader is a Reader for the VolumeDelete structure.
type VolumeDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VolumeDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewVolumeDeleteNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewVolumeDeleteNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewVolumeDeleteConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewVolumeDeleteInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewVolumeDeleteNoContent creates a VolumeDeleteNoContent with default headers values
func NewVolumeDeleteNoContent() *VolumeDeleteNoContent {
	return &VolumeDeleteNoContent{}
}

/*
VolumeDeleteNoContent describes a response with status code 204, with default header values.

no error
*/
type VolumeDeleteNoContent struct {
}

// IsSuccess returns true when this volume delete no content response has a 2xx status code
func (o *VolumeDeleteNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this volume delete no content response has a 3xx status code
func (o *VolumeDeleteNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume delete no content response has a 4xx status code
func (o *VolumeDeleteNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume delete no content response has a 5xx status code
func (o *VolumeDeleteNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this volume delete no content response a status code equal to that given
func (o *VolumeDeleteNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *VolumeDeleteNoContent) Error() string {
	return fmt.Sprintf("[DELETE /volumes/{name}][%d] volumeDeleteNoContent ", 204)
}

func (o *VolumeDeleteNoContent) String() string {
	return fmt.Sprintf("[DELETE /volumes/{name}][%d] volumeDeleteNoContent ", 204)
}

func (o *VolumeDeleteNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVolumeDeleteNotFound creates a VolumeDeleteNotFound with default headers values
func NewVolumeDeleteNotFound() *VolumeDeleteNotFound {
	return &VolumeDeleteNotFound{}
}

/*
VolumeDeleteNotFound describes a response with status code 404, with default header values.

No such volume
*/
type VolumeDeleteNotFound struct {
	Payload *VolumeDeleteNotFoundBody
}

// IsSuccess returns true when this volume delete not found response has a 2xx status code
func (o *VolumeDeleteNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this volume delete not found response has a 3xx status code
func (o *VolumeDeleteNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume delete not found response has a 4xx status code
func (o *VolumeDeleteNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this volume delete not found response has a 5xx status code
func (o *VolumeDeleteNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this volume delete not found response a status code equal to that given
func (o *VolumeDeleteNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *VolumeDeleteNotFound) Error() string {
	return fmt.Sprintf("[DELETE /volumes/{name}][%d] volumeDeleteNotFound  %+v", 404, o.Payload)
}

func (o *VolumeDeleteNotFound) String() string {
	return fmt.Sprintf("[DELETE /volumes/{name}][%d] volumeDeleteNotFound  %+v", 404, o.Payload)
}

func (o *VolumeDeleteNotFound) GetPayload() *VolumeDeleteNotFoundBody {
	return o.Payload
}

func (o *VolumeDeleteNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(VolumeDeleteNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVolumeDeleteConflict creates a VolumeDeleteConflict with default headers values
func NewVolumeDeleteConflict() *VolumeDeleteConflict {
	return &VolumeDeleteConflict{}
}

/*
VolumeDeleteConflict describes a response with status code 409, with default header values.

Volume is in use and cannot be removed
*/
type VolumeDeleteConflict struct {
}

// IsSuccess returns true when this volume delete conflict response has a 2xx status code
func (o *VolumeDeleteConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this volume delete conflict response has a 3xx status code
func (o *VolumeDeleteConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume delete conflict response has a 4xx status code
func (o *VolumeDeleteConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this volume delete conflict response has a 5xx status code
func (o *VolumeDeleteConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this volume delete conflict response a status code equal to that given
func (o *VolumeDeleteConflict) IsCode(code int) bool {
	return code == 409
}

func (o *VolumeDeleteConflict) Error() string {
	return fmt.Sprintf("[DELETE /volumes/{name}][%d] volumeDeleteConflict ", 409)
}

func (o *VolumeDeleteConflict) String() string {
	return fmt.Sprintf("[DELETE /volumes/{name}][%d] volumeDeleteConflict ", 409)
}

func (o *VolumeDeleteConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVolumeDeleteInternalServerError creates a VolumeDeleteInternalServerError with default headers values
func NewVolumeDeleteInternalServerError() *VolumeDeleteInternalServerError {
	return &VolumeDeleteInternalServerError{}
}

/*
VolumeDeleteInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type VolumeDeleteInternalServerError struct {
	Payload *VolumeDeleteInternalServerErrorBody
}

// IsSuccess returns true when this volume delete internal server error response has a 2xx status code
func (o *VolumeDeleteInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this volume delete internal server error response has a 3xx status code
func (o *VolumeDeleteInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this volume delete internal server error response has a 4xx status code
func (o *VolumeDeleteInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this volume delete internal server error response has a 5xx status code
func (o *VolumeDeleteInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this volume delete internal server error response a status code equal to that given
func (o *VolumeDeleteInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *VolumeDeleteInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /volumes/{name}][%d] volumeDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *VolumeDeleteInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /volumes/{name}][%d] volumeDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *VolumeDeleteInternalServerError) GetPayload() *VolumeDeleteInternalServerErrorBody {
	return o.Payload
}

func (o *VolumeDeleteInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(VolumeDeleteInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VolumeDeleteInternalServerErrorBody volume delete internal server error body
swagger:model VolumeDeleteInternalServerErrorBody
*/
type VolumeDeleteInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this volume delete internal server error body
func (o *VolumeDeleteInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume delete internal server error body based on context it is used
func (o *VolumeDeleteInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeDeleteInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeDeleteInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res VolumeDeleteInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VolumeDeleteNotFoundBody volume delete not found body
swagger:model VolumeDeleteNotFoundBody
*/
type VolumeDeleteNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this volume delete not found body
func (o *VolumeDeleteNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this volume delete not found body based on context it is used
func (o *VolumeDeleteNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VolumeDeleteNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VolumeDeleteNotFoundBody) UnmarshalBinary(b []byte) error {
	var res VolumeDeleteNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
