// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LinuxResources LinuxResources has container runtime resource constraints
//
// swagger:model LinuxResources
type LinuxResources struct {

	// Devices configures the device allowlist.
	Devices []*LinuxDeviceCgroup `json:"devices"`

	// Hugetlb limit (in bytes)
	HugepageLimits []*LinuxHugepageLimit `json:"hugepageLimits"`

	// Rdma resource restriction configuration.
	// Limits are a set of key value pairs that define RDMA resource limits,
	// where the key is device name and value is resource limits.
	Rdma map[string]LinuxRdma `json:"rdma,omitempty"`

	// Unified resources.
	Unified map[string]string `json:"unified,omitempty"`

	// block i o
	BlockIO *LinuxBlockIO `json:"blockIO,omitempty"`

	// cpu
	CPU *LinuxCPU `json:"cpu,omitempty"`

	// memory
	Memory *LinuxMemory `json:"memory,omitempty"`

	// network
	Network *LinuxNetwork `json:"network,omitempty"`

	// pids
	Pids *LinuxPids `json:"pids,omitempty"`
}

// Validate validates this linux resources
func (m *LinuxResources) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDevices(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHugepageLimits(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRdma(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBlockIO(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCPU(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMemory(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetwork(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePids(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LinuxResources) validateDevices(formats strfmt.Registry) error {
	if swag.IsZero(m.Devices) { // not required
		return nil
	}

	for i := 0; i < len(m.Devices); i++ {
		if swag.IsZero(m.Devices[i]) { // not required
			continue
		}

		if m.Devices[i] != nil {
			if err := m.Devices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("devices" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LinuxResources) validateHugepageLimits(formats strfmt.Registry) error {
	if swag.IsZero(m.HugepageLimits) { // not required
		return nil
	}

	for i := 0; i < len(m.HugepageLimits); i++ {
		if swag.IsZero(m.HugepageLimits[i]) { // not required
			continue
		}

		if m.HugepageLimits[i] != nil {
			if err := m.HugepageLimits[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("hugepageLimits" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("hugepageLimits" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LinuxResources) validateRdma(formats strfmt.Registry) error {
	if swag.IsZero(m.Rdma) { // not required
		return nil
	}

	for k := range m.Rdma {

		if err := validate.Required("rdma"+"."+k, "body", m.Rdma[k]); err != nil {
			return err
		}
		if val, ok := m.Rdma[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rdma" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("rdma" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *LinuxResources) validateBlockIO(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockIO) { // not required
		return nil
	}

	if m.BlockIO != nil {
		if err := m.BlockIO.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("blockIO")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("blockIO")
			}
			return err
		}
	}

	return nil
}

func (m *LinuxResources) validateCPU(formats strfmt.Registry) error {
	if swag.IsZero(m.CPU) { // not required
		return nil
	}

	if m.CPU != nil {
		if err := m.CPU.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cpu")
			}
			return err
		}
	}

	return nil
}

func (m *LinuxResources) validateMemory(formats strfmt.Registry) error {
	if swag.IsZero(m.Memory) { // not required
		return nil
	}

	if m.Memory != nil {
		if err := m.Memory.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("memory")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("memory")
			}
			return err
		}
	}

	return nil
}

func (m *LinuxResources) validateNetwork(formats strfmt.Registry) error {
	if swag.IsZero(m.Network) { // not required
		return nil
	}

	if m.Network != nil {
		if err := m.Network.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("network")
			}
			return err
		}
	}

	return nil
}

func (m *LinuxResources) validatePids(formats strfmt.Registry) error {
	if swag.IsZero(m.Pids) { // not required
		return nil
	}

	if m.Pids != nil {
		if err := m.Pids.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pids")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pids")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this linux resources based on the context it is used
func (m *LinuxResources) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDevices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHugepageLimits(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRdma(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBlockIO(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCPU(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMemory(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetwork(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePids(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LinuxResources) contextValidateDevices(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Devices); i++ {

		if m.Devices[i] != nil {
			if err := m.Devices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("devices" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LinuxResources) contextValidateHugepageLimits(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.HugepageLimits); i++ {

		if m.HugepageLimits[i] != nil {
			if err := m.HugepageLimits[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("hugepageLimits" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("hugepageLimits" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LinuxResources) contextValidateRdma(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.Rdma {

		if val, ok := m.Rdma[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *LinuxResources) contextValidateBlockIO(ctx context.Context, formats strfmt.Registry) error {

	if m.BlockIO != nil {
		if err := m.BlockIO.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("blockIO")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("blockIO")
			}
			return err
		}
	}

	return nil
}

func (m *LinuxResources) contextValidateCPU(ctx context.Context, formats strfmt.Registry) error {

	if m.CPU != nil {
		if err := m.CPU.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cpu")
			}
			return err
		}
	}

	return nil
}

func (m *LinuxResources) contextValidateMemory(ctx context.Context, formats strfmt.Registry) error {

	if m.Memory != nil {
		if err := m.Memory.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("memory")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("memory")
			}
			return err
		}
	}

	return nil
}

func (m *LinuxResources) contextValidateNetwork(ctx context.Context, formats strfmt.Registry) error {

	if m.Network != nil {
		if err := m.Network.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("network")
			}
			return err
		}
	}

	return nil
}

func (m *LinuxResources) contextValidatePids(ctx context.Context, formats strfmt.Registry) error {

	if m.Pids != nil {
		if err := m.Pids.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pids")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pids")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LinuxResources) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LinuxResources) UnmarshalBinary(b []byte) error {
	var res LinuxResources
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
