package org.jboss.cmp2.crimeportal;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;

import org.apache.log4j.Category;

public abstract class LocationBean implements EntityBean
{
   private EntityContext ctx;
   private Category log = Category.getInstance(getClass());

   public Integer ejbCreate() throws CreateException
   {
      return null;
   }

   public void ejbPostCreate()
   {
      Object id = ctx.getPrimaryKey();
      log.debug("ejbPostCreate, id="+id);
   }

   public Integer ejbCreate(String description, String street, String city,
         String state, int zipCode) throws CreateException
   {
      setDescription(description);
      setStreet(street);
      setCity(city);
      setState(state);
      setZipCode(zipCode);
      return null;
   }

   public void ejbPostCreate(String description, String street, String city, 
         String state, int zipCode) throws CreateException
   {
      Object id = ctx.getPrimaryKey();
      log.debug("ejbPostCreate, id="+id);
   }

   public abstract Integer getLocationID();
   public abstract void setLocationID(Integer id);

   /**
    * Gets the address description.
    * @return description of the address
    */
   public abstract String getDescription();

   /**
    * Sets the address description.
    * @param description new address description
    */
   public abstract void setDescription(String description);

   /**
    * Gets the address street.
    * @return street of the address
    */
   public abstract String getStreet();

   /**
    * Sets the address street.
    * @param street new address street
    */
   public abstract void setStreet(String street);
 
   /**
    * Gets the city of the address.
    * @return city of the address
    */
   public abstract String getCity();

   /**
    * Sets the city for the address.
    * @param city the new city for the address
    */
   public abstract void setCity(String city);

   /**
    * Gets the two letter state code for the address.
    * @return the two letter state code
    */
   public abstract String getState();

   /**
    * Sets the two letter state code for the address.
    * @param state the new two letter state code for the address
    * @throws IllegalArgumentException if the state does not contain 
    * exactally two letters
    */
   public abstract void setState(String state);
   
   /**
    * Gets the zip code of the address.
    * @return the address zip code
    */
   public abstract int getZipCode();

   /**
    * Sets the zip code of the address.
    * @param zipCode the new zip code for the address
    * @throws IllegalArgumentException if the zip code is a negative number
    * or if the zipCode has more then five digits.
    */
   public abstract void setZipCode(int zipCode);

   // EJB callbacks -----------------------------------------------------------
   public void setEntityContext(EntityContext context)
   {
      ctx = context;
   }

   public void unsetEntityContext()
   {
      ctx = null;
   }

   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }

   public void ejbRemove()
   {
   }

   public void ejbStore()
   {
   }

   public void ejbLoad()
   {
   }
}
