/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi;

import javax.naming.NamingException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.rmi.JNDIRegistration;
import org.apache.juddi.subscription.SubscriptionNotifier;
import org.apache.log4j.Logger;

public class Registry {
    private static Registry registry = null;
    private static Logger log = Logger.getLogger(Registry.class);
    private static SubscriptionNotifier subscriptionNotifier = null;

    private Registry() {
    }

    public static synchronized void stop() throws ConfigurationException {
        if (registry != null) {
            log.info((Object)"Stopping jUDDI registry...");
            if (subscriptionNotifier != null) {
                log.info((Object)"Shutting down SubscriptionNotifier");
                subscriptionNotifier.cancel();
                subscriptionNotifier = null;
            }
            if (AppConfig.getConfiguration().getBoolean("juddi.jndi.registration", false)) {
                try {
                    JNDIRegistration.getInstance().unregister();
                }
                catch (NamingException e) {
                    log.error((Object)("Unable to Register jUDDI services with JNDI. " + e.getMessage()), (Throwable)e);
                }
            }
            registry = null;
            log.info((Object)"jUDDI shutdown completed.");
        }
    }

    public static synchronized void start() throws ConfigurationException {
        if (registry == null) {
            log.info((Object)"Starting jUDDI registry...");
            registry = new Registry();
            if (AppConfig.getConfiguration().getBoolean("juddi.subscription.notification", true)) {
                subscriptionNotifier = new SubscriptionNotifier();
            }
            if (AppConfig.getConfiguration().getBoolean("juddi.jndi.registration", false)) {
                try {
                    JNDIRegistration.getInstance().register();
                }
                catch (NamingException e) {
                    log.error((Object)("Unable to Register jUDDI services with JNDI. " + e.getMessage()), (Throwable)e);
                }
            }
            log.info((Object)"jUDDI registry started succesfully.");
        }
    }
}

