/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.XRegisterHelper;
import org.apache.juddi.api_v3.ClerkDetail;
import org.apache.juddi.api_v3.ClientSubscriptionInfoDetail;
import org.apache.juddi.api_v3.DeleteClientSubscriptionInfo;
import org.apache.juddi.api_v3.DeletePublisher;
import org.apache.juddi.api_v3.GetAllClientSubscriptionInfoDetail;
import org.apache.juddi.api_v3.GetAllPublisherDetail;
import org.apache.juddi.api_v3.GetClientSubscriptionInfoDetail;
import org.apache.juddi.api_v3.GetPublisherDetail;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.api_v3.NodeDetail;
import org.apache.juddi.api_v3.PublisherDetail;
import org.apache.juddi.api_v3.SaveClerk;
import org.apache.juddi.api_v3.SaveClientSubscriptionInfo;
import org.apache.juddi.api_v3.SaveNode;
import org.apache.juddi.api_v3.SavePublisher;
import org.apache.juddi.api_v3.SyncSubscription;
import org.apache.juddi.api_v3.SyncSubscriptionDetail;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingApiToModel;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.Clerk;
import org.apache.juddi.model.ClientSubscriptionInfo;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.subscription.NotificationList;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.apache.juddi.validation.ValidateClerk;
import org.apache.juddi.validation.ValidateClientSubscriptionInfo;
import org.apache.juddi.validation.ValidateNode;
import org.apache.juddi.validation.ValidatePublish;
import org.apache.juddi.validation.ValidatePublisher;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.sub_v3.GetSubscriptionResults;
import org.uddi.sub_v3.SubscriptionResultsList;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDISubscriptionPortType;

@WebService(serviceName="JUDDIApiService", endpointInterface="org.apache.juddi.v3_service.JUDDIApiPortType", targetNamespace="urn:juddi-apache-org:v3_service")
public class JUDDIApiImpl
extends AuthenticatedService
implements JUDDIApiPortType {
    private Logger log = Logger.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublisherDetail savePublisher(SavePublisher body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateSavePublisher(em, body);
            PublisherDetail result = new PublisherDetail();
            List apiPublisherList = body.getPublisher();
            for (org.apache.juddi.api_v3.Publisher apiPublisher : apiPublisherList) {
                Publisher modelPublisher = new Publisher();
                MappingApiToModel.mapPublisher(apiPublisher, modelPublisher);
                Object existingUddiEntity = em.find(modelPublisher.getClass(), (Object)modelPublisher.getAuthorizedName());
                if (existingUddiEntity != null) {
                    em.remove(existingUddiEntity);
                }
                em.persist((Object)modelPublisher);
                result.getPublisher().add(apiPublisher);
            }
            tx.commit();
            PublisherDetail publisherDetail = result;
            return publisherDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePublisher(DeletePublisher body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeletePublisher(em, body);
            List entityKeyList = body.getPublisherId();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(Publisher.class, (Object)entityKey);
                em.remove(obj);
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublisherDetail getPublisherDetail(GetPublisherDetail body) throws DispositionReportFaultMessage {
        new ValidatePublisher(null).validateGetPublisherDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            PublisherDetail result = new PublisherDetail();
            List publisherIdList = body.getPublisherId();
            for (String publisherId : publisherIdList) {
                Publisher modelPublisher = (Publisher)em.find(Publisher.class, (Object)publisherId);
                if (modelPublisher == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.PublisherNotFound", publisherId));
                }
                org.apache.juddi.api_v3.Publisher apiPublisher = new org.apache.juddi.api_v3.Publisher();
                MappingModelToApi.mapPublisher(modelPublisher, apiPublisher);
                result.getPublisher().add(apiPublisher);
            }
            tx.commit();
            PublisherDetail publisherDetail = result;
            return publisherDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublisherDetail getAllPublisherDetail(GetAllPublisherDetail body) throws DispositionReportFaultMessage, RemoteException {
        new ValidatePublisher(null).validateGetAllPublisherDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            PublisherDetail result = new PublisherDetail();
            Query query = em.createQuery("SELECT p from Publisher as p");
            List modelPublisherList = query.getResultList();
            for (Publisher modelPublisher : modelPublisherList) {
                org.apache.juddi.api_v3.Publisher apiPublisher = new org.apache.juddi.api_v3.Publisher();
                MappingModelToApi.mapPublisher(modelPublisher, apiPublisher);
                result.getPublisher().add(apiPublisher);
            }
            tx.commit();
            PublisherDetail publisherDetail = result;
            return publisherDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adminDeleteTModel(DeleteTModel body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateAdminDeleteTModel(em, body);
            List entityKeyList = body.getTModelKey();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(Tmodel.class, (Object)entityKey);
                em.remove(obj);
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteClientSubscriptionInfo(DeleteClientSubscriptionInfo body) throws DispositionReportFaultMessage, RemoteException {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateClientSubscriptionInfo(publisher).validateDeleteClientSubscriptionInfo(em, body);
            List entityKeyList = body.getSubscriptionKey();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(ClientSubscriptionInfo.class, (Object)entityKey);
                em.remove(obj);
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSubscriptionInfoDetail saveClientSubscriptionInfo(SaveClientSubscriptionInfo body) throws DispositionReportFaultMessage, RemoteException {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateClientSubscriptionInfo(publisher).validateSaveClientSubscriptionInfo(em, body);
            ClientSubscriptionInfoDetail result = new ClientSubscriptionInfoDetail();
            List apiClientSubscriptionInfoList = body.getClientSubscriptionInfo();
            for (org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo : apiClientSubscriptionInfoList) {
                ClientSubscriptionInfo modelClientSubscriptionInfo = new ClientSubscriptionInfo();
                MappingApiToModel.mapClientSubscriptionInfo(apiClientSubscriptionInfo, modelClientSubscriptionInfo);
                Object existingUddiEntity = em.find(modelClientSubscriptionInfo.getClass(), (Object)modelClientSubscriptionInfo.getSubscriptionKey());
                if (existingUddiEntity != null) {
                    em.remove(existingUddiEntity);
                }
                em.persist((Object)modelClientSubscriptionInfo);
                result.getClientSubscriptionInfo().add(apiClientSubscriptionInfo);
            }
            tx.commit();
            ClientSubscriptionInfoDetail clientSubscriptionInfoDetail = result;
            return clientSubscriptionInfoDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSubscriptionInfoDetail getAllClientSubscriptionInfoDetail(GetAllClientSubscriptionInfoDetail body) throws DispositionReportFaultMessage {
        new ValidateClientSubscriptionInfo(null).validateGetAllClientSubscriptionDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            ClientSubscriptionInfoDetail result = new ClientSubscriptionInfoDetail();
            Query query = em.createQuery("SELECT cs from ClientSubscriptionInfo as cs");
            List modelClientSubscriptionInfoList = query.getResultList();
            for (ClientSubscriptionInfo modelClientSubscriptionInfo : modelClientSubscriptionInfoList) {
                org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo = new org.apache.juddi.api_v3.ClientSubscriptionInfo();
                MappingModelToApi.mapClientSubscriptionInfo(modelClientSubscriptionInfo, apiClientSubscriptionInfo);
                result.getClientSubscriptionInfo().add(apiClientSubscriptionInfo);
            }
            tx.commit();
            ClientSubscriptionInfoDetail clientSubscriptionInfoDetail = result;
            return clientSubscriptionInfoDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSubscriptionInfoDetail getClientSubscriptionInfoDetail(GetClientSubscriptionInfoDetail body) throws DispositionReportFaultMessage {
        new ValidateClientSubscriptionInfo(null).validateGetClientSubscriptionInfoDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            ClientSubscriptionInfoDetail result = new ClientSubscriptionInfoDetail();
            List subscriptionKeyList = body.getClientSubscriptionKey();
            for (String subscriptionKey : subscriptionKeyList) {
                ClientSubscriptionInfo modelClientSubscriptionInfo = (ClientSubscriptionInfo)em.find(ClientSubscriptionInfo.class, (Object)subscriptionKey);
                if (modelClientSubscriptionInfo == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.SubscripKeyNotFound", subscriptionKey));
                }
                org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo = new org.apache.juddi.api_v3.ClientSubscriptionInfo();
                MappingModelToApi.mapClientSubscriptionInfo(modelClientSubscriptionInfo, apiClientSubscriptionInfo);
                result.getClientSubscriptionInfo().add(apiClientSubscriptionInfo);
            }
            tx.commit();
            ClientSubscriptionInfoDetail clientSubscriptionInfoDetail = result;
            return clientSubscriptionInfoDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClerkDetail saveClerk(SaveClerk body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateClerk(publisher).validateSaveClerk(em, body);
            ClerkDetail result = new ClerkDetail();
            List apiClerkList = body.getClerk();
            for (org.apache.juddi.api_v3.Clerk apiClerk : apiClerkList) {
                Clerk modelClerk = new Clerk();
                MappingApiToModel.mapClerk(apiClerk, modelClerk);
                Object existingUddiEntity = em.find(modelClerk.getClass(), (Object)modelClerk.getClerkName());
                if (existingUddiEntity != null) {
                    em.merge((Object)modelClerk);
                } else {
                    em.persist((Object)modelClerk);
                }
                result.getClerk().add(apiClerk);
            }
            tx.commit();
            ClerkDetail clerkDetail = result;
            return clerkDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeDetail saveNode(SaveNode body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidateNode(publisher).validateSaveNode(em, body);
            NodeDetail result = new NodeDetail();
            List apiNodeList = body.getNode();
            for (Node apiNode : apiNodeList) {
                org.apache.juddi.model.Node modelNode = new org.apache.juddi.model.Node();
                MappingApiToModel.mapNode(apiNode, modelNode);
                Object existingUddiEntity = em.find(modelNode.getClass(), (Object)modelNode.getName());
                if (existingUddiEntity != null) {
                    em.merge((Object)modelNode);
                } else {
                    em.persist((Object)modelNode);
                }
                result.getNode().add(apiNode);
            }
            tx.commit();
            NodeDetail nodeDetail = result;
            return nodeDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncSubscriptionDetail invokeSyncSubscription(SyncSubscription body) throws DispositionReportFaultMessage, RemoteException {
        String subscriptionKey;
        SyncSubscriptionDetail syncSubscriptionDetail = new SyncSubscriptionDetail();
        HashMap<String, org.apache.juddi.api_v3.ClientSubscriptionInfo> clientSubscriptionInfoMap = new HashMap<String, org.apache.juddi.api_v3.ClientSubscriptionInfo>();
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            this.getEntityPublisher(em, body.getAuthInfo());
            for (GetSubscriptionResults getSubscriptionResult : body.getGetSubscriptionResultsList()) {
                subscriptionKey = getSubscriptionResult.getSubscriptionKey();
                ClientSubscriptionInfo modelClientSubscriptionInfo = (ClientSubscriptionInfo)em.find(ClientSubscriptionInfo.class, (Object)subscriptionKey);
                if (modelClientSubscriptionInfo == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.SubscripKeyNotFound", subscriptionKey));
                }
                org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo = new org.apache.juddi.api_v3.ClientSubscriptionInfo();
                MappingModelToApi.mapClientSubscriptionInfo(modelClientSubscriptionInfo, apiClientSubscriptionInfo);
                clientSubscriptionInfoMap.put(apiClientSubscriptionInfo.getSubscriptionKey(), apiClientSubscriptionInfo);
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        for (GetSubscriptionResults getSubscriptionResult : body.getGetSubscriptionResultsList()) {
            try {
                subscriptionKey = getSubscriptionResult.getSubscriptionKey();
                org.apache.juddi.api_v3.Clerk fromClerk = ((org.apache.juddi.api_v3.ClientSubscriptionInfo)clientSubscriptionInfoMap.get(subscriptionKey)).getFromClerk();
                org.apache.juddi.api_v3.Clerk toClerk = ((org.apache.juddi.api_v3.ClientSubscriptionInfo)clientSubscriptionInfoMap.get(subscriptionKey)).getToClerk();
                String clazz = fromClerk.getNode().getProxyTransport();
                Class transportClass = Loader.loadClass((String)clazz);
                Transport transport = (Transport)transportClass.getConstructor(String.class).newInstance(fromClerk.getNode().getName());
                UDDISubscriptionPortType subscriptionService = transport.getUDDISubscriptionService(fromClerk.getNode().getSubscriptionUrl());
                SubscriptionResultsList list = subscriptionService.getSubscriptionResults(getSubscriptionResult);
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{list.getClass()});
                Marshaller marshaller = context.createMarshaller();
                StringWriter sw = new StringWriter();
                marshaller.marshal((Object)list, (Writer)sw);
                this.log.info((Object)("Notification received by UDDISubscriptionListenerService : " + sw.toString()));
                NotificationList<String> nl = NotificationList.getInstance();
                nl.getNotifications().add((Object)sw.toString());
                XRegisterHelper.handle(fromClerk, toClerk, list);
                syncSubscriptionDetail.getSubscriptionResultsList().add(list);
            }
            catch (Exception ce) {
                this.log.error((Object)ce.getMessage(), (Throwable)ce);
                if (ce instanceof DispositionReportFaultMessage) {
                    throw (DispositionReportFaultMessage)ce;
                }
                if (!(ce instanceof RemoteException)) continue;
                throw (RemoteException)ce;
            }
        }
        return syncSubscriptionDetail;
    }
}

