/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.cryptor;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.cryptor.Cryptor;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;

public abstract class CryptorFactory {
    private static Logger log = Logger.getLogger(CryptorFactory.class);
    private static Cryptor cryptor = null;

    public static Cryptor getCryptor() {
        if (cryptor == null) {
            cryptor = CryptorFactory.createCryptor();
        }
        return cryptor;
    }

    private static synchronized Cryptor createCryptor() {
        if (cryptor != null) {
            return cryptor;
        }
        String className = "org.apache.juddi.cryptor.DefaultCryptor";
        try {
            className = AppConfig.getConfiguration().getString("juddi.cryptor", "org.apache.juddi.cryptor.DefaultCryptor");
        }
        catch (ConfigurationException ce) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.cryptor", (Throwable)ce);
        }
        log.debug((Object)("Cryptor Implementation = " + className));
        Class cryptorClass = null;
        try {
            cryptorClass = Loader.loadClass((String)className);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("The specified Cryptor class '" + className + "' was not found in classpath."));
            log.error((Object)e);
        }
        try {
            cryptor = (Cryptor)cryptorClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Exception while attempting to instantiate the implementation of Cryptor: " + cryptorClass.getName() + "\n" + e.getMessage()));
            log.error((Object)e);
        }
        return cryptor;
    }
}

