/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.juddi.model.Address;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.ContactDescr;
import org.apache.juddi.model.Email;
import org.apache.juddi.model.PersonName;
import org.apache.juddi.model.Phone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="j3_contact")
public class Contact
implements Serializable {
    private static final long serialVersionUID = 3350341195850056589L;
    private Long id;
    private BusinessEntity businessEntity;
    private String useType;
    private List<PersonName> personNames = new ArrayList<PersonName>(0);
    private List<ContactDescr> contactDescrs = new ArrayList<ContactDescr>(0);
    private List<Email> emails = new ArrayList<Email>(0);
    private List<Phone> phones = new ArrayList<Phone>(0);
    private List<Address> addresses = new ArrayList<Address>(0);

    public Contact() {
    }

    public Contact(BusinessEntity businessEntity) {
        this.businessEntity = businessEntity;
    }

    public Contact(BusinessEntity businessEntity, String useType, List<PersonName> personNames, List<ContactDescr> contactDescrs, List<Email> emails, List<Phone> phones, List<Address> addresses) {
        this.businessEntity = businessEntity;
        this.useType = useType;
        this.personNames = personNames;
        this.contactDescrs = contactDescrs;
        this.emails = emails;
        this.phones = phones;
        this.addresses = addresses;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="entity_key", nullable=false)
    public BusinessEntity getBusinessEntity() {
        return this.businessEntity;
    }

    public void setBusinessEntity(BusinessEntity businessEntity) {
        this.businessEntity = businessEntity;
    }

    @Column(name="use_type")
    public String getUseType() {
        return this.useType;
    }

    public void setUseType(String useType) {
        this.useType = useType;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="contact")
    @OrderBy
    public List<PersonName> getPersonNames() {
        return this.personNames;
    }

    public void setPersonNames(List<PersonName> personNames) {
        this.personNames = personNames;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="contact")
    @OrderBy
    public List<ContactDescr> getContactDescrs() {
        return this.contactDescrs;
    }

    public void setContactDescrs(List<ContactDescr> contactDescrs) {
        this.contactDescrs = contactDescrs;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="contact")
    @OrderBy
    public List<Email> getEmails() {
        return this.emails;
    }

    public void setEmails(List<Email> emails) {
        this.emails = emails;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="contact")
    @OrderBy
    public List<Phone> getPhones() {
        return this.phones;
    }

    public void setPhones(List<Phone> phones) {
        this.phones = phones;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="contact")
    @OrderBy
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }
}

