/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.juddi.model.UddiEntityPublisher;

@Entity
@Table(name="j3_publisher")
public class Publisher
extends UddiEntityPublisher
implements Serializable {
    private static final long serialVersionUID = 1960575191518050887L;
    private String publisherName;
    private String emailAddress;
    private String isAdmin;
    private String isEnabled;
    private Integer maxBusinesses;
    private Integer maxServicesPerBusiness;
    private Integer maxBindingsPerService;
    private Integer maxTmodels;

    public Publisher() {
        super(null);
    }

    public Publisher(String publisherId, String publisherName) {
        super(publisherId);
        this.authorizedName = publisherId;
        this.publisherName = publisherName;
    }

    public Publisher(String publisherId, String publisherName, String emailAddress, String isAdmin, String isEnabled, Integer maxBusinesses, Integer maxServicesPerBusiness, Integer maxBindingsPerService, Integer maxTmodels) {
        super(publisherId);
        this.authorizedName = publisherId;
        this.publisherName = publisherName;
        this.emailAddress = emailAddress;
        this.isAdmin = isAdmin;
        this.isEnabled = isEnabled;
        this.maxBusinesses = maxBusinesses;
        this.maxServicesPerBusiness = maxServicesPerBusiness;
        this.maxBindingsPerService = maxBindingsPerService;
        this.maxTmodels = maxTmodels;
    }

    @Column(name="publisher_name", nullable=false)
    public String getPublisherName() {
        return this.publisherName;
    }

    public void setPublisherName(String publisherName) {
        this.publisherName = publisherName;
    }

    @Column(name="email_address")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Column(name="is_admin", length=5)
    public String getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(String isAdmin) {
        this.isAdmin = isAdmin;
    }

    @Transient
    public boolean isAdmin() {
        boolean ret = false;
        if (this.getIsAdmin() != null && this.getIsAdmin().equalsIgnoreCase("true")) {
            ret = true;
        }
        return ret;
    }

    @Column(name="is_enabled", length=5)
    public String getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(String isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Transient
    public boolean isEnabled() {
        boolean ret = false;
        if (this.getIsEnabled() != null && this.getIsEnabled().equalsIgnoreCase("true")) {
            ret = true;
        }
        return ret;
    }

    @Column(name="max_businesses")
    public Integer getMaxBusinesses() {
        return this.maxBusinesses;
    }

    public void setMaxBusinesses(Integer maxBusinesses) {
        this.maxBusinesses = maxBusinesses;
    }

    @Column(name="max_services_per_business")
    public Integer getMaxServicesPerBusiness() {
        return this.maxServicesPerBusiness;
    }

    public void setMaxServicesPerBusiness(Integer maxServicesPerBusiness) {
        this.maxServicesPerBusiness = maxServicesPerBusiness;
    }

    @Column(name="max_bindings_per_service")
    public Integer getMaxBindingsPerService() {
        return this.maxBindingsPerService;
    }

    public void setMaxBindingsPerService(Integer maxBindingsPerService) {
        this.maxBindingsPerService = maxBindingsPerService;
    }

    @Column(name="max_tmodels")
    public Integer getMaxTmodels() {
        return this.maxTmodels;
    }

    public void setMaxTmodels(Integer maxTmodels) {
        this.maxTmodels = maxTmodels;
    }
}

