/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.model;

import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.ServiceProjectionId;

@Entity
@Table(name="j3_service_projection")
public class ServiceProjection
implements Serializable {
    private static final long serialVersionUID = -8404899558507142913L;
    @EmbeddedId
    private ServiceProjectionId id = new ServiceProjectionId();
    @ManyToOne
    @JoinColumn(name="business_key", insertable=false, updatable=false)
    private BusinessEntity businessEntity;
    @ManyToOne
    @JoinColumn(name="service_key", insertable=false, updatable=false)
    private BusinessService businessService;

    public ServiceProjection() {
    }

    public ServiceProjection(BusinessEntity businessEntity, BusinessService businessService) {
        this.businessEntity = businessEntity;
        this.businessService = businessService;
        this.id.businessKey = businessEntity.entityKey;
        this.id.serviceKey = businessService.entityKey;
        businessEntity.getServiceProjections().add(this);
        businessService.getProjectingBusinesses().add(this);
    }

    public ServiceProjectionId getId() {
        return this.id;
    }

    public void setId(ServiceProjectionId id) {
        this.id = id;
    }

    public BusinessEntity getBusinessEntity() {
        return this.businessEntity;
    }

    public void setBusinessEntity(BusinessEntity businessEntity) {
        this.businessEntity = businessEntity;
    }

    public BusinessService getBusinessService() {
        return this.businessService;
    }

    public void setBusinessService(BusinessService businessService) {
        this.businessService = businessService;
    }
}

