/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.query.EntityQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindEntityByPublisherQuery
extends EntityQuery {
    public static final String AUTHORIZED_NAME_FIELD = "authorizedName";
    private String entityName;
    private String entityAlias;
    private String keyName;
    private String selectSQL;

    public FindEntityByPublisherQuery(String entityName, String entityAlias, String keyName) {
        this.entityName = entityName;
        this.entityAlias = entityAlias;
        this.keyName = keyName;
        StringBuffer sql = new StringBuffer(200);
        sql.append("select distinct " + entityAlias + "." + keyName + " from " + entityName + " " + entityAlias + " ");
        this.selectSQL = sql.toString();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getSelectSQL() {
        return this.selectSQL;
    }

    public List<?> select(EntityManager em, FindQualifiers fq, UddiEntityPublisher publisher, List<?> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        if (publisher == null) {
            return keysIn;
        }
        DynamicQuery dynamicQry = new DynamicQuery(this.selectSQL);
        this.appendConditions(dynamicQry, fq, publisher);
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        return FindEntityByPublisherQuery.getQueryResult(em, dynamicQry, keysIn, this.entityAlias + "." + this.keyName);
    }

    public void appendConditions(DynamicQuery qry, FindQualifiers fq, UddiEntityPublisher publisher) {
        qry.WHERE().pad();
        qry.appendGroupedAnd(new DynamicQuery.Parameter(this.entityAlias + "." + AUTHORIZED_NAME_FIELD, publisher.getAuthorizedName(), DynamicQuery.PREDICATE_EQUALS));
    }
}

