/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.auth;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.auth.Authenticator;
import org.apache.juddi.v3.auth.AuthenticatorFactory;
import org.apache.juddi.v3.auth.JuddiUsers;
import org.apache.juddi.v3.auth.User;
import org.apache.juddi.v3.error.AuthenticationException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.UnknownUserException;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;

public class XMLDocAuthenticator
implements Authenticator {
    private static Logger log = Logger.getLogger(AuthenticatorFactory.class);
    Hashtable<String, User> userTable;

    public XMLDocAuthenticator() throws JAXBException, IOException, ConfigurationException {
        this.readUserFile();
    }

    protected String getFilename() throws ConfigurationException {
        return AppConfig.getConfiguration().getString("juddi.usersfile", "juddi-users.xml");
    }

    public synchronized void readUserFile() throws JAXBException, IOException, ConfigurationException {
        this.userTable = new Hashtable();
        String usersFileName = this.getFilename();
        log.info((Object)("Reading jUDDI Users File: " + usersFileName + "..."));
        InputStream stream = Loader.getResource((String)usersFileName).openStream();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{JuddiUsers.class});
        Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
        JAXBElement element = unMarshaller.unmarshal((Source)new StreamSource(stream), JuddiUsers.class);
        JuddiUsers users = (JuddiUsers)element.getValue();
        for (User user : users.getUser()) {
            this.userTable.put(user.getUserid(), user);
            log.debug((Object)("Loading user credentials for user: " + user.getUserid()));
        }
    }

    public String authenticate(String userID, String credential) throws AuthenticationException, FatalErrorException {
        if (userID == null) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidUserId", userID));
        }
        if (credential == null) {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidCredentials"));
        }
        if (this.userTable.containsKey(userID)) {
            User user = this.userTable.get(userID);
            if (user.getPassword() == null || !credential.equals(user.getPassword())) {
                throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidCredentials"));
            }
        } else {
            throw new UnknownUserException(new ErrorMessage("errors.auth.InvalidUserId", userID));
        }
        return userID;
    }

    public UddiEntityPublisher identify(String authInfo, String authorizedName) throws AuthenticationException {
        return new UddiEntityPublisher(authorizedName);
    }
}

