/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.RunnerContext;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wsi.WSIReportPanel;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.WSISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import org.wsI.testing.x2003.x03.common.AddStyleSheet;
import org.wsI.testing.x2003.x03.log.Environment;
import org.wsI.testing.x2003.x03.log.HttpMessageEntry;
import org.wsI.testing.x2003.x03.log.Implementation;
import org.wsI.testing.x2003.x03.log.Log;
import org.wsI.testing.x2003.x03.log.LogDocument;
import org.wsI.testing.x2003.x03.log.MessageEntry;
import org.wsI.testing.x2003.x03.log.Monitor;
import org.wsI.testing.x2003.x03.log.NameVersionPair;
import org.wsI.testing.x2003.x03.log.TcpMessageType;
import org.wsI.testing.x2004.x07.analyzerConfig.AssertionResults;
import org.wsI.testing.x2004.x07.analyzerConfig.Configuration;
import org.wsI.testing.x2004.x07.analyzerConfig.ConfigurationDocument;
import org.wsI.testing.x2004.x07.analyzerConfig.LogFile;
import org.wsI.testing.x2004.x07.analyzerConfig.ReportFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSIValidateResponseAction
extends AbstractToolsAction<WsdlMockResponse> {
    private String configFile;
    private File logFile;

    public WSIValidateResponseAction(WsdlMockResponse request) {
        super(request, "Check WS-I Compliance", "Validates the current request/response againt the WS-I Basic Profile");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt W"));
        this.setEnabled(request != null && request.getMockResult() != null);
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost) throws Exception {
        if (((WsdlMockResponse)this.modelItem).getMockResult() == null) {
            UISupport.showErrorMessage("Request/Response required for WS-I validations");
            return;
        }
        String wsiDir = SoapUI.getSettings().getString(WSISettings.WSI_LOCATION, null);
        if (wsiDir == null) {
            UISupport.showErrorMessage("WSI Test Tools directory must be set in global preferences");
            return;
        }
        if (((WsdlMockResponse)this.modelItem).getAttachmentCount() > 0 && !UISupport.confirm("Response contains attachments which is not supported by validation tools, validate anyway?", "Validation Warning")) {
            return;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        File reportFile = File.createTempFile("wsi-report", ".xml");
        ArgumentBuilder args = this.buildArgs(reportFile);
        builder.command(args.getArgs());
        builder.directory(new File(wsiDir + File.separatorChar + "java" + File.separatorChar + "bin"));
        toolHost.run(new WSIProcessToolRunner(builder, reportFile));
    }

    private ArgumentBuilder buildArgs(File reportFile) throws Exception {
        File logFile = this.buildLog();
        File file = this.buildConfig(reportFile, logFile);
        Settings settings = ((WsdlMockResponse)this.modelItem).getSettings();
        ArgumentBuilder builder = new ArgumentBuilder(new StringToStringMap());
        builder.startScript("Analyzer", ".bat", ".sh");
        builder.addArgs("-config", file.getAbsolutePath());
        if (settings.getBoolean(WSISettings.ASSERTION_DESCRIPTION)) {
            builder.addArgs("-assertionDescription", "true");
        }
        return builder;
    }

    private File buildLog() throws Exception {
        LogDocument logDoc = LogDocument.Factory.newInstance();
        Log log = logDoc.addNewLog();
        log.setTimestamp(Calendar.getInstance());
        this.addMonitorConfig(log);
        this.addMessageConfig(log);
        this.logFile = File.createTempFile("wsi-analyzer-log", ".xml");
        logDoc.save(this.logFile);
        return this.logFile;
    }

    private File buildConfig(File reportFile, File logFile) throws IOException {
        Settings settings = ((WsdlMockResponse)this.modelItem).getSettings();
        ConfigurationDocument configDoc = ConfigurationDocument.Factory.newInstance();
        Configuration config = configDoc.addNewConfiguration();
        config.setVerbose(settings.getBoolean(WSISettings.VERBOSE));
        AssertionResults results = config.addNewAssertionResults();
        results.setType(AssertionResults.Type.Enum.forString((String)settings.getString(WSISettings.RESULTS_TYPE, AssertionResults.Type.ONLY_FAILED.toString())));
        results.setMessageEntry(settings.getBoolean(WSISettings.MESSAGE_ENTRY));
        results.setFailureMessage(settings.getBoolean(WSISettings.FAILURE_MESSAGE));
        results.setAssertionDescription(settings.getBoolean(WSISettings.ASSERTION_DESCRIPTION));
        ReportFile report = config.addNewReportFile();
        report.setLocation(reportFile.getAbsolutePath());
        report.setReplace(true);
        AddStyleSheet stylesheet = report.addNewAddStyleSheet();
        stylesheet.setHref(".\\..\\common\\Profiles\\SSBP10_BP11_TAD.xml");
        stylesheet.setType("text/xsl");
        stylesheet.setAlternate(false);
        config.setTestAssertionsFile("../../common/profiles/SSBP10_BP11_TAD.xml");
        LogFile logFileConfig = config.addNewLogFile();
        logFileConfig.setStringValue(logFile.getAbsolutePath());
        logFileConfig.setCorrelationType(LogFile.CorrelationType.ENDPOINT);
        this.configFile = configDoc.toString();
        File file = File.createTempFile("wsi-analyzer-config", ".xml");
        configDoc.save(file);
        return file;
    }

    private void addMessageConfig(Log log) throws MalformedURLException {
        HttpMessageEntry requestMessage = HttpMessageEntry.Factory.newInstance();
        WsdlMockRequest mockRequest = ((WsdlMockResponse)this.modelItem).getMockResult().getMockRequest();
        requestMessage.addNewMessageContent().setStringValue(mockRequest.getRequestContent());
        requestMessage.setConversationID("1");
        requestMessage.setTimestamp(Calendar.getInstance());
        requestMessage.setID("1");
        WsdlMockService mockService = ((WsdlMockResponse)this.modelItem).getMockOperation().getMockService();
        URL endpoint = new URL("http://127.0.0.1:" + mockService.getPort() + mockService.getPath());
        requestMessage.setSenderHostAndPort("localhost");
        if (endpoint.getPort() > 0) {
            requestMessage.setReceiverHostAndPort(endpoint.getHost() + ":" + endpoint.getPort());
        } else {
            requestMessage.setReceiverHostAndPort(endpoint.getHost());
        }
        requestMessage.setType(TcpMessageType.REQUEST);
        HttpMessageEntry responseMessage = HttpMessageEntry.Factory.newInstance();
        responseMessage.addNewMessageContent().setStringValue(((WsdlMockResponse)this.modelItem).getMockResult().getResponseContent());
        responseMessage.setConversationID("1");
        responseMessage.setType(TcpMessageType.RESPONSE);
        responseMessage.setTimestamp(Calendar.getInstance());
        responseMessage.setID("2");
        responseMessage.setSenderHostAndPort(requestMessage.getReceiverHostAndPort());
        responseMessage.setReceiverHostAndPort(requestMessage.getSenderHostAndPort());
        String requestHeaders = this.buildHttpHeadersString(mockRequest.getRequestHeaders());
        requestMessage.setHttpHeaders("POST " + mockRequest.getPath() + " " + mockRequest.getProtocol() + "\r\n" + requestHeaders);
        responseMessage.setHttpHeaders("HTTP/1.1 200 OK" + this.buildHttpHeadersString(((WsdlMockResponse)this.modelItem).getMockResult().getResponseHeaders()));
        log.setMessageEntryArray(new MessageEntry[]{requestMessage, responseMessage});
    }

    private void addMonitorConfig(Log log) throws Exception {
        Monitor monitor = log.addNewMonitor();
        monitor.setVersion("1.5");
        monitor.setReleaseDate(Calendar.getInstance());
        org.wsI.testing.x2003.x03.monitorConfig.Configuration conf = monitor.addNewConfiguration();
        conf.setCleanupTimeoutSeconds(0);
        conf.setLogDuration(0);
        org.wsI.testing.x2003.x03.monitorConfig.LogFile logFileConf = conf.addNewLogFile();
        logFileConf.setLocation("report.xml");
        logFileConf.setReplace(true);
        Environment env = monitor.addNewEnvironment();
        NameVersionPair osConf = env.addNewOperatingSystem();
        osConf.setName("Windows");
        osConf.setVersion("2003");
        NameVersionPair rtConf = env.addNewRuntime();
        rtConf.setName("java");
        rtConf.setVersion("1.5");
        NameVersionPair xpConf = env.addNewXmlParser();
        xpConf.setName("xmlbeans");
        xpConf.setVersion("2.2.0");
        Implementation implConf = monitor.addNewImplementer();
        implConf.setName("soapui");
        implConf.setLocation("here");
    }

    private String buildHttpHeadersString(StringToStringMap requestHeaders) {
        StringBuffer buffer = new StringBuffer();
        if (requestHeaders.containsKey("#status#")) {
            buffer.append((String)requestHeaders.get("#status#")).append("\r\n");
        }
        for (String header : requestHeaders.keySet()) {
            if (header.equals("#status#")) continue;
            buffer.append(header).append(": ").append((String)requestHeaders.get(header)).append("\r\n");
        }
        return buffer.toString();
    }

    private class WSIProcessToolRunner
    extends ProcessToolRunner {
        private final File reportFile;

        public WSIProcessToolRunner(ProcessBuilder builder, File reportFile) {
            super(builder, "WSI Message Validation", WSIValidateResponseAction.this.modelItem);
            this.reportFile = reportFile;
        }

        public String getDescription() {
            return "Running WSI Analysis tools..";
        }

        protected void afterRun(int exitCode, RunnerContext context) {
            try {
                if (exitCode == 0 && context.getStatus() == RunnerContext.RunnerStatus.FINISHED) {
                    WSIReportPanel panel = new WSIReportPanel(this.reportFile, WSIValidateResponseAction.this.configFile, WSIValidateResponseAction.this.logFile);
                    panel.setPreferredSize(new Dimension(600, 400));
                    UISupport.showDesktopPanel(new DefaultDesktopPanel("WS-I Report", "WS-I Report for validation of messages in MockResponse [" + ((WsdlMockResponse)WSIValidateResponseAction.this.modelItem).getName() + "]", panel));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                UISupport.showErrorMessage(e);
            }
        }

        public boolean showLog() {
            return ((WsdlMockResponse)WSIValidateResponseAction.this.modelItem).getSettings().getBoolean(WSISettings.SHOW_LOG);
        }
    }
}

