/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.AttachmentUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class WsdlRequestDataSource
implements DataSource {
    private final WsdlRequest wsdlRequest;
    private final String requestContent;
    private final boolean isXOP;

    public WsdlRequestDataSource(WsdlRequest wsdlRequest, String requestContent, boolean isXOP) {
        this.wsdlRequest = wsdlRequest;
        this.requestContent = requestContent;
        this.isXOP = isXOP;
    }

    public String getContentType() {
        if (this.isXOP) {
            return AttachmentUtils.buildRootPartContentType(this.wsdlRequest.getOperation().getName(), this.wsdlRequest.getOperation().getInterface().getSoapVersion());
        }
        return "text/xml; charset=UTF-8";
    }

    public InputStream getInputStream() throws IOException {
        byte[] bytes = this.requestContent.getBytes("UTF-8");
        return new ByteArrayInputStream(bytes);
    }

    public String getName() {
        return this.wsdlRequest.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }
}

