/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.CallConfig;
import com.eviware.soapui.config.RequestStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.actions.CloneTestStepAction;
import com.eviware.soapui.impl.wsdl.teststeps.actions.SelectOperationAction;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionError;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.support.TestStepBeanProperty;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.action.ActionSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class WsdlTestRequestStep
extends WsdlTestStep
implements PropertyChangeListener {
    private static final Logger log = Logger.getLogger(WsdlTestRequestStep.class);
    private RequestStepConfig requestStepConfig;
    private WsdlTestRequest testRequest;
    private WsdlOperation wsdlOperation;
    private final InternalProjectListener projectListener = new InternalProjectListener();
    private final InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private final InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();

    public WsdlTestRequestStep(WsdlTestCase testCase, TestStepConfig config) {
        super(testCase, config, true);
        if (testCase != null && testCase.getTestSuite() != null) {
            testCase.getTestSuite().addTestSuiteListener(this.testSuiteListener);
        }
        if (((TestStepConfig)this.getConfig()).getConfig() != null) {
            this.requestStepConfig = (RequestStepConfig)((TestStepConfig)this.getConfig()).getConfig().changeType(RequestStepConfig.type);
            this.wsdlOperation = this.findWsdlOperation();
            if (this.wsdlOperation == null) {
                log.error((Object)("Could not find operation [" + this.requestStepConfig.getOperation() + "] in interface [" + this.requestStepConfig.getInterface() + "] for test request"));
                this.requestStepConfig.setRequest(null);
            } else {
                this.wsdlOperation.getInterface().getProject().addProjectListener(this.projectListener);
                this.wsdlOperation.getInterface().addInterfaceListener(this.interfaceListener);
                this.wsdlOperation.getInterface().addPropertyChangeListener(this);
                this.wsdlOperation.addPropertyChangeListener(this);
                this.testRequest = new WsdlTestRequest(this.wsdlOperation, this.requestStepConfig.getRequest(), this);
                this.testRequest.addPropertyChangeListener(this);
                config.setName(this.testRequest.getName());
            }
        } else {
            this.requestStepConfig = (RequestStepConfig)((TestStepConfig)this.getConfig()).addNewConfig().changeType(RequestStepConfig.type);
        }
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new SelectOperationAction(this));
        this.addAction(new CloneTestStepAction(this, "TestRequest"));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/testrequests.html"));
        this.addProperty(new TestStepBeanProperty("Endpoint", false, this.testRequest, "endpoint", this));
        this.addProperty(new TestStepBeanProperty("Username", false, this.testRequest, "username", this));
        this.addProperty(new TestStepBeanProperty("Password", false, this.testRequest, "password", this));
        this.addProperty(new TestStepBeanProperty("Domain", false, this.testRequest, "domain", this));
        this.addProperty(new TestStepBeanProperty("Request", false, this.testRequest, "requestContent", this));
        this.addProperty(new TestStepBeanProperty("Response", true, this.testRequest, "responseContent", this));
    }

    public WsdlTestRequestStep(WsdlTestCase testCase, TestStepConfig testStep, WsdlRequest request) {
        this(testCase, testStep);
        this.requestStepConfig.setInterface(request.getOperation().getInterface().getName());
        this.requestStepConfig.setOperation(request.getOperation().getName());
        CallConfig testRequestConfig = this.requestStepConfig.getRequest();
        if (testRequestConfig == null) {
            testRequestConfig = this.requestStepConfig.addNewRequest();
        }
        testRequestConfig.setName(request.getName());
        testRequestConfig.setEncoding(request.getEncoding());
        testRequestConfig.setEndpoint(request.getEndpoint());
        testRequestConfig.setRequest(request.getRequestContent());
        if (((CallConfig)request.getConfig()).getCredentials() != null) {
            testRequestConfig.setCredentials(((CallConfig)request.getConfig()).getCredentials());
        }
        this.testRequest = new WsdlTestRequest(request.getOperation(), testRequestConfig, this);
        request.copyAttachmentsTo(this.testRequest);
        this.testRequest.addPropertyChangeListener(this);
        this.wsdlOperation = this.findWsdlOperation();
        if (this.wsdlOperation == null) {
            throw new RuntimeException("Failed to find operation [" + this.requestStepConfig.getOperation() + "] for test request");
        }
        this.wsdlOperation.getInterface().addInterfaceListener(this.interfaceListener);
        this.wsdlOperation.getInterface().getProject().addProjectListener(this.projectListener);
    }

    public WsdlTestRequestStep(WsdlTestCase testCase, WsdlTestRequest sourceRequest) {
        this(testCase, TestStepConfig.Factory.newInstance(), sourceRequest);
    }

    public WsdlTestStep clone(WsdlTestCase targetTestCase, String name) {
        TestStepConfig config = (TestStepConfig)((TestStepConfig)this.getConfig()).copy();
        RequestStepConfig stepConfig = (RequestStepConfig)config.getConfig().changeType(RequestStepConfig.type);
        while (stepConfig.getRequest().sizeOfAttachmentArray() > 0) {
            stepConfig.getRequest().removeAttachment(0);
        }
        config.setName(name);
        stepConfig.getRequest().setName(name);
        WsdlTestRequestStep result = (WsdlTestRequestStep)targetTestCase.addTestStep(config);
        this.testRequest.copyAttachmentsTo(result.getTestRequest());
        return result;
    }

    private WsdlOperation findWsdlOperation() {
        WsdlTestCase testCase = this.getTestCase();
        if (testCase == null || testCase.getTestSuite() == null) {
            return null;
        }
        WsdlProject project = testCase.getTestSuite().getProject();
        WsdlOperation operation = null;
        for (int c = 0; c < project.getInterfaceCount(); ++c) {
            if (!project.getInterfaceAt(c).getName().equals(this.requestStepConfig.getInterface())) continue;
            WsdlInterface iface = (WsdlInterface)project.getInterfaceAt(c);
            for (int i = 0; i < iface.getOperationCount(); ++i) {
                if (!iface.getOperationAt(i).getName().equals(this.requestStepConfig.getOperation())) continue;
                operation = iface.getOperationAt(i);
                break;
            }
            if (operation != null) break;
        }
        return operation;
    }

    public void release() {
        super.release();
        this.wsdlOperation = this.findWsdlOperation();
        if (this.wsdlOperation != null) {
            this.wsdlOperation.removePropertyChangeListener(this);
            this.wsdlOperation.getInterface().getProject().removeProjectListener(this.projectListener);
            this.wsdlOperation.getInterface().removeInterfaceListener(this.interfaceListener);
            this.wsdlOperation.getInterface().removePropertyChangeListener(this);
        }
        this.testRequest.removePropertyChangeListener(this);
        this.testRequest.release();
    }

    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.requestStepConfig = (RequestStepConfig)config.getConfig().changeType(RequestStepConfig.type);
        this.testRequest.updateConfig(this.requestStepConfig.getRequest());
    }

    public ImageIcon getIcon() {
        return this.testRequest.getIcon();
    }

    public String getName() {
        return this.testRequest == null ? super.getName() : this.testRequest.getName();
    }

    public WsdlTestRequest getTestRequest() {
        return this.testRequest;
    }

    public void setName(String name) {
        this.testRequest.setName(name);
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getSource() == this.wsdlOperation) {
            if (arg0.getPropertyName().equals(Operation.NAME_PROPERTY)) {
                this.requestStepConfig.setOperation((String)arg0.getNewValue());
            }
        } else if (arg0.getSource() == this.wsdlOperation.getInterface()) {
            if (arg0.getPropertyName().equals(Interface.NAME_PROPERTY)) {
                this.requestStepConfig.setInterface((String)arg0.getNewValue());
            }
        } else {
            this.notifyPropertyChanged(arg0.getPropertyName(), arg0.getOldValue(), arg0.getNewValue());
        }
    }

    public TestStepResult run(TestRunner runner, TestRunContext runContext) {
        LoadTestRunner loadTestRunner = (LoadTestRunner)runContext.getProperty("LoadTestRunner");
        if (loadTestRunner != null) {
            this.testRequest.getIconAnimator().setEnabled(false);
        }
        WsdlTestRequestStepResult testStepResult = new WsdlTestRequestStepResult(this);
        try {
            Submit submit = this.testRequest.submit(runContext, false);
            WsdlResponse response = (WsdlResponse)submit.getResponse();
            if (submit.getStatus() != Submit.Status.CANCELED) {
                if (submit.getStatus() == Submit.Status.ERROR) {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    testStepResult.addMessage(submit.getError().toString());
                    this.testRequest.setResponse(null, runContext);
                } else if (response == null) {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    testStepResult.addMessage("Request is missing response");
                    this.testRequest.setResponse(null, runContext);
                } else {
                    this.testRequest.setResponse(response, runContext);
                    testStepResult.setTimeTaken(response.getTimeTaken());
                    testStepResult.setSize(response.getContentLength());
                    testStepResult.setResponse(response);
                    switch (this.testRequest.getAssertionStatus()) {
                        case FAILED: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                            break;
                        }
                        case VALID: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.OK);
                            break;
                        }
                        case UNKNOWN: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.UNKNOWN);
                        }
                    }
                }
            } else {
                testStepResult.setStatus(TestStepResult.TestStepStatus.CANCELED);
                testStepResult.addMessage("Request was canceled");
            }
            if (response != null) {
                testStepResult.setRequestContent(response.getRequestContent());
            }
        }
        catch (Request.SubmitException e) {
            testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
            testStepResult.addMessage("SubmitException: " + e);
        }
        testStepResult.setDomain(this.testRequest.getDomain());
        testStepResult.setUsername(this.testRequest.getUsername());
        testStepResult.setPassword(this.testRequest.getPassword());
        testStepResult.setEndpoint(PropertyExpansionRequestFilter.expandProperties(runContext, this.testRequest.getEndpoint()));
        testStepResult.setEncoding(this.testRequest.getEncoding());
        if (testStepResult.getStatus() != TestStepResult.TestStepStatus.CANCELED) {
            Assertable.AssertionStatus assertionStatus = this.testRequest.getAssertionStatus();
            switch (assertionStatus) {
                case FAILED: {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    if (this.getAssertionCount() == 0) {
                        testStepResult.addMessage("Invalid/empty response");
                        break;
                    }
                    for (int c = 0; c < this.getAssertionCount(); ++c) {
                        AssertionError[] errors = this.getAssertionAt(c).getErrors();
                        if (errors == null) continue;
                        for (AssertionError error : errors) {
                            testStepResult.addMessage(error.getMessage());
                        }
                    }
                    break;
                }
            }
        }
        this.testRequest.getIconAnimator().setEnabled(true);
        return testStepResult;
    }

    public WsdlMessageAssertion getAssertionAt(int index) {
        return this.testRequest.getAssertionAt(index);
    }

    public int getAssertionCount() {
        return this.testRequest.getAssertionCount();
    }

    public boolean cancel() {
        return false;
    }

    public boolean dependsOn(AbstractWsdlModelItem modelItem) {
        if (modelItem instanceof Interface && this.testRequest.getOperation().getInterface() == modelItem) {
            return true;
        }
        return modelItem instanceof Operation && this.testRequest.getOperation() == modelItem;
    }

    private class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testStepRemoved(TestStep testStep, int index) {
            if (testStep == WsdlTestRequestStep.this) {
                log.debug((Object)"Releasing WsdlTestRequestStep");
                WsdlTestRequestStep.this.wsdlOperation.getInterface().removeInterfaceListener(WsdlTestRequestStep.this.interfaceListener);
                WsdlTestRequestStep.this.wsdlOperation.getInterface().getProject().removeProjectListener(WsdlTestRequestStep.this.projectListener);
                WsdlTestRequestStep.this.getTestCase().getTestSuite().removeTestSuiteListener(WsdlTestRequestStep.this.testSuiteListener);
            }
        }
    }

    public class InternalInterfaceListener
    extends InterfaceListenerAdapter {
        public void operationRemoved(Operation operation) {
            if (operation.equals(WsdlTestRequestStep.this.wsdlOperation)) {
                WsdlTestRequestStep.this.getTestCase().removeTestStep(WsdlTestRequestStep.this);
            }
        }
    }

    public class InternalProjectListener
    extends ProjectListenerAdapter {
        public void interfaceRemoved(Interface iface) {
            if (WsdlTestRequestStep.this.wsdlOperation != null && WsdlTestRequestStep.this.wsdlOperation.getInterface().equals(iface)) {
                log.debug((Object)"Removing test step due to removed interface");
                WsdlTestRequestStep.this.getTestCase().removeTestStep(WsdlTestRequestStep.this);
            }
        }
    }
}

