/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.support;

import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.actions.ShowMessageExchangeAction;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;

public class WsdlMessageExchangeStepResult
extends WsdlTestStepResult {
    private SoftReference<WsdlMessageExchange> messageExchange;
    private SoftReference<StringToStringMap> properties;

    public WsdlMessageExchangeStepResult(WsdlTestStep step) {
        super(step);
    }

    public void setMessageExchange(WsdlMessageExchange messageExchange) {
        this.messageExchange = new SoftReference<WsdlMessageExchange>(messageExchange);
        this.addAction(new ShowMessageExchangeAction(messageExchange, "StepResult"), true);
    }

    public String getRequestContent() {
        if (this.isDiscarded()) {
            return "<discarded>";
        }
        if (this.messageExchange != null && this.messageExchange.get() == null) {
            return "<garbage-collected>";
        }
        return this.messageExchange == null ? null : this.messageExchange.get().getRequestContent();
    }

    public void addProperty(String name, String value) {
        if (this.isDiscarded()) {
            return;
        }
        if (this.properties == null) {
            this.properties = new SoftReference<StringToStringMap>(new StringToStringMap());
        }
        this.properties.get().put(name, value);
    }

    public void discard() {
        super.discard();
        this.messageExchange = null;
        this.properties = null;
    }

    public void writeTo(PrintWriter writer) {
        WsdlMessageExchange me;
        StringToStringMap map;
        super.writeTo(writer);
        if (this.isDiscarded()) {
            return;
        }
        writer.println("---------------- Properties ------------------------");
        StringToStringMap stringToStringMap = map = this.properties == null ? null : this.properties.get();
        if (map == null || map.isEmpty()) {
            writer.println("Missing Properties");
        } else {
            for (String name : map.keySet()) {
                writer.println(name + ": " + (String)map.get(name));
            }
        }
        writer.println("---------------- Message Exchange ------------------");
        WsdlMessageExchange wsdlMessageExchange = me = this.messageExchange == null ? null : this.messageExchange.get();
        if (me == null) {
            writer.println("Missing MessageExchange");
        } else {
            writer.println("--- Request");
            if (me.getRequestHeaders() != null) {
                writer.println("Request Headers: " + me.getRequestHeaders().toString());
            }
            writer.println(XmlUtils.prettyPrintXml(me.getRequestContent()));
            writer.println("--- Response");
            if (me.getResponseHeaders() != null) {
                writer.println("Response Headers: " + me.getResponseHeaders().toString());
            }
            writer.println(XmlUtils.prettyPrintXml(me.getResponseContent()));
        }
    }

    public StringToStringMap getProperties() {
        return this.properties == null ? null : this.properties.get();
    }
}

