/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.policy.assertion;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.ComplexAssertion;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.spi.AssertionCreationException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.policy.assertion.DeliveryAssuranceAssertion;
import com.sun.xml.ws.rm.policy.assertion.RmAssertionInstantiator;
import java.util.Collection;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Rm11Assertion
extends ComplexAssertion {
    public static final QName NAME = new QName(RmVersion.WSRM11.policyNamespaceUri, "RMAssertion");
    private static final RmLogger LOGGER = RmLogger.getLogger(Rm11Assertion.class);
    private static final QName SEQUENCE_STR_QNAME = new QName(RmVersion.WSRM11.policyNamespaceUri, "SequenceSTR");
    private static final QName SEQUENCE_TRANSPORT_SECURITY_QNAME = new QName(RmVersion.WSRM11.policyNamespaceUri, "SequenceTransportSecurity");
    private static RmAssertionInstantiator instantiator = new RmAssertionInstantiator(){

        @Override
        public PolicyAssertion newInstance(AssertionData data, Collection<PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
            return new Rm11Assertion(data, assertionParameters, nestedAlternative);
        }
    };
    private final Configuration.SecurityBinding securityBinding;
    private final DeliveryAssuranceAssertion deliveryAssuranceAssertion;

    public static RmAssertionInstantiator getInstantiator() {
        return instantiator;
    }

    private Rm11Assertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
        super(data, assertionParameters, nestedAlternative);
        Configuration.SecurityBinding _securityBinding = Configuration.SecurityBinding.NONE;
        DeliveryAssuranceAssertion _deliveryAssuranceAssertion = null;
        if (nestedAlternative != null) {
            for (PolicyAssertion nestedAssertion : nestedAlternative) {
                if (SEQUENCE_STR_QNAME.equals(nestedAssertion.getName())) {
                    _securityBinding = this.evaluateDeliveryAssurance(_securityBinding == Configuration.SecurityBinding.NONE, Configuration.SecurityBinding.STR, data);
                    continue;
                }
                if (SEQUENCE_TRANSPORT_SECURITY_QNAME.equals(nestedAssertion.getName())) {
                    _securityBinding = this.evaluateDeliveryAssurance(_securityBinding == Configuration.SecurityBinding.NONE, Configuration.SecurityBinding.TRANSPORT, data);
                    continue;
                }
                if (!DeliveryAssuranceAssertion.NAME.equals(nestedAssertion.getName())) continue;
                _deliveryAssuranceAssertion = (DeliveryAssuranceAssertion)nestedAssertion;
            }
        }
        if (_deliveryAssuranceAssertion == null) {
            throw LOGGER.logSevereException(new AssertionCreationException(data, LocalizationMessages.WSRM_1004_EXPECTED_DA_NOT_SPECIFIED_IN_POLICY()));
        }
        this.securityBinding = _securityBinding;
        this.deliveryAssuranceAssertion = _deliveryAssuranceAssertion;
    }

    public Configuration.DeliveryAssurance getDeliveryAssurance() {
        return this.deliveryAssuranceAssertion.getDeliveryAssurance();
    }

    public boolean isOrderedDelivery() {
        return this.deliveryAssuranceAssertion.isOrderedDelivery();
    }

    public Configuration.SecurityBinding getSecurityBinding() {
        return this.securityBinding;
    }

    private Configuration.SecurityBinding evaluateDeliveryAssurance(boolean successCondition, Configuration.SecurityBinding bindingOnSuccess, AssertionData data) throws AssertionCreationException {
        if (successCondition) {
            return bindingOnSuccess;
        }
        throw LOGGER.logSevereException(new AssertionCreationException(data, LocalizationMessages.WSRM_1005_MULTIPLE_SECURITY_BINDINGS_IN_POLICY()));
    }
}

