/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolCommunicator {
    private static final RmLogger LOGGER = RmLogger.getLogger(ProtocolCommunicator.class);
    private volatile Engine fiberEngine;
    private final ReadWriteLock fiberEngineLock = new ReentrantReadWriteLock();
    private final AtomicReference<Packet> musterRequestPacket;
    public final QName soapMustUnderstandAttributeName;
    private final Tube tubeline;
    private final SecureConversationInitiator scInitiator;
    private final Configuration configuration;

    public ProtocolCommunicator(Tube tubeline, SecureConversationInitiator scInitiator, Configuration configuration) {
        this.tubeline = tubeline;
        this.scInitiator = scInitiator;
        if (configuration.getAddressingVersion() != AddressingVersion.W3C) {
            throw LOGGER.logSevereException(new IllegalStateException(LocalizationMessages.WSRM_1120_UNSUPPORTED_WSA_VERSION()));
        }
        this.configuration = configuration;
        this.soapMustUnderstandAttributeName = new QName(configuration.getSoapVersion().nsUri, "mustUnderstand");
        this.musterRequestPacket = new AtomicReference();
    }

    public void registerMusterRequestPacket(Packet muster) {
        this.musterRequestPacket.set(muster);
    }

    public SecurityTokenReferenceType tryStartSecureConversation() {
        JAXBElement strElement = null;
        if (this.scInitiator != null) {
            try {
                strElement = this.scInitiator.startSecureConversation(this.musterRequestPacket.get().copy(false));
            }
            catch (WSSecureConversationException ex) {
                LOGGER.severe(LocalizationMessages.WSRM_1121_SECURE_CONVERSATION_INIT_FAILED(), ex);
            }
        }
        return strElement != null ? (SecurityTokenReferenceType)strElement.getValue() : null;
    }

    public Message createMessage(Object jaxbElement) {
        return Messages.create(this.configuration.getRmVersion().jaxbContext, jaxbElement, this.configuration.getSoapVersion());
    }

    public Message createEmptyMessage() {
        return Messages.createEmpty(this.configuration.getSoapVersion());
    }

    protected final Header createHeader(Object jaxbHeaderContent) {
        return Headers.create(this.configuration.getRmVersion().jaxbContext, jaxbHeaderContent);
    }

    public final <T> T readHeaderAsUnderstood(HeaderList headers, String name) throws RmException {
        Header header = headers.get(this.configuration.getRmVersion().namespaceUri, name, true);
        if (header == null) {
            return (T)((Object)null);
        }
        try {
            return header.readAsJAXB(this.configuration.getRmVersion().jaxbUnmarshaller);
        }
        catch (JAXBException ex) {
            throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_1122_ERROR_MARSHALLING_RM_HEADER(this.configuration.getRmVersion().namespaceUri + "#" + name), ex));
        }
    }

    public final <T> T unmarshallMessage(Message message) throws RmException {
        try {
            return message.readPayloadAsJAXB(this.configuration.getRmVersion().jaxbUnmarshaller);
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_1123_ERROR_UNMARSHALLING_MESSAGE(), e));
        }
    }

    public Message send(Message requestMessage, String action) {
        Fiber fiber = this.getFiberEngine().createFiber();
        Packet responsePacket = fiber.runSync(this.tubeline, this.createPacket(requestMessage, action));
        return responsePacket.getMessage();
    }

    public String getAction(Message message) {
        return message.getHeaders().getAction(this.configuration.getAddressingVersion(), this.configuration.getSoapVersion());
    }

    public WSEndpointReference getDestination() {
        Packet packet = this.musterRequestPacket.get();
        return packet != null ? new WSEndpointReference(packet.endpointAddress.toString(), this.configuration.getAddressingVersion()) : null;
    }

    private Packet createPacket(Message message, String action) {
        Packet newPacket = this.musterRequestPacket.get().copy(false);
        newPacket.setMessage(message);
        message.assertOneWay(false);
        message.getHeaders().fillRequestAddressingHeaders(newPacket, this.configuration.getAddressingVersion(), this.configuration.getSoapVersion(), false, action);
        return newPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Engine getFiberEngine() {
        try {
            this.fiberEngineLock.readLock().lock();
            if (this.fiberEngine == null) {
                this.fiberEngineLock.readLock().unlock();
                try {
                    this.fiberEngineLock.writeLock().lock();
                    if (this.fiberEngine == null) {
                        this.fiberEngine = Fiber.current().owner;
                    }
                }
                finally {
                    this.fiberEngineLock.readLock().lock();
                    this.fiberEngineLock.writeLock().unlock();
                }
            }
            Engine engine = this.fiberEngine;
            return engine;
        }
        finally {
            this.fiberEngineLock.readLock().unlock();
        }
    }
}

