/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policyconv.BindingProcessor;
import com.sun.xml.ws.security.impl.policyconv.EncryptionAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.IntegrityAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.TokenProcessor;
import com.sun.xml.ws.security.impl.policyconv.XWSSPolicyContainer;
import com.sun.xml.ws.security.policy.AsymmetricBinding;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.EncryptedElements;
import com.sun.xml.ws.security.policy.EncryptedParts;
import com.sun.xml.ws.security.policy.SignedElements;
import com.sun.xml.ws.security.policy.SignedParts;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsymmetricBindingProcessor
extends BindingProcessor {
    private AsymmetricBinding binding = null;

    public AsymmetricBindingProcessor(AsymmetricBinding asBinding, XWSSPolicyContainer container, boolean isServer, boolean isIncoming, Vector<SignedParts> signedParts, Vector<EncryptedParts> encryptedParts, Vector<SignedElements> signedElements, Vector<EncryptedElements> encryptedElements) {
        this.binding = asBinding;
        this.container = container;
        this.isServer = isServer;
        this.isIncoming = isIncoming;
        this.protectionOrder = this.binding.getProtectionOrder();
        this.tokenProcessor = new TokenProcessor(isServer, isIncoming, this.pid);
        this.iAP = new IntegrityAssertionProcessor(this.binding.getAlgorithmSuite(), this.binding.isSignContent());
        this.eAP = new EncryptionAssertionProcessor(this.binding.getAlgorithmSuite(), false);
        this.signedParts = signedParts;
        this.signedElements = signedElements;
        this.encryptedElements = encryptedElements;
        this.encryptedParts = encryptedParts;
    }

    public void process() throws PolicyException {
        Token st = this.getSignatureToken();
        Token et = this.getEncryptionToken();
        if (st != null) {
            this.primarySP = new SignaturePolicy();
            this.primarySP.setUUID(this.pid.generateID());
            if (Constants.logger.isLoggable(Level.FINEST)) {
                Constants.logger.log(Level.FINEST, "ID of Primary signature policy is " + this.primarySP.getUUID());
            }
            this.tokenProcessor.addKeyBinding(this.primarySP, st, true);
            SignaturePolicy.FeatureBinding spFB = (SignaturePolicy.FeatureBinding)this.primarySP.getFeatureBinding();
            SecurityPolicyUtil.setCanonicalizationMethod(spFB, this.binding.getAlgorithmSuite());
            spFB.isPrimarySignature(true);
        }
        if (et != null) {
            this.primaryEP = new EncryptionPolicy();
            this.primaryEP.setUUID(this.pid.generateID());
            this.tokenProcessor.addKeyBinding(this.primaryEP, et, false);
            if (Constants.logger.isLoggable(Level.FINEST)) {
                Constants.logger.log(Level.FINEST, "ID of Encryption policy is " + this.primaryEP.getUUID());
            }
        }
        if (this.protectionOrder == "SignBeforeEncrypting") {
            this.container.insert(this.primarySP);
        } else {
            this.container.insert(this.primaryEP);
            this.container.insert(this.primarySP);
        }
        this.addPrimaryTargets();
        if (this.foundEncryptTargets && this.binding.getSignatureProtection()) {
            if (Constants.logger.isLoggable(Level.FINEST)) {
                Constants.logger.log(Level.FINEST, "PrimarySignature will be Encrypted");
            }
            this.protectPrimarySignature();
        }
        if (this.binding.isIncludeTimeStamp()) {
            if (Constants.logger.isLoggable(Level.FINEST)) {
                Constants.logger.log(Level.FINEST, "Timestamp header will be added to the message and will be Integrity protected ");
            }
            TimestampPolicy tp = new TimestampPolicy();
            tp.setUUID(this.pid.generateID());
            this.container.insert(tp);
            if (!this.binding.isDisableTimestampSigning()) {
                this.protectTimestamp(tp);
            }
        }
        if (this.binding.getTokenProtection()) {
            if (Constants.logger.isLoggable(Level.FINEST)) {
                Constants.logger.log(Level.FINEST, "Token reference by primary signature with ID " + this.primarySP.getUUID() + " will be Integrity protected");
            }
            this.protectToken((WSSPolicy)this.primarySP.getKeyBinding());
        }
    }

    protected Token getEncryptionToken() {
        if (this.isServer && !this.isIncoming || !this.isServer && this.isIncoming) {
            return this.binding.getInitiatorToken();
        }
        return this.binding.getRecipientToken();
    }

    protected Token getSignatureToken() {
        if (this.isServer && !this.isIncoming || !this.isServer && this.isIncoming) {
            return this.binding.getRecipientToken();
        }
        return this.binding.getInitiatorToken();
    }

    @Override
    protected Binding getBinding() {
        return this.binding;
    }

    @Override
    protected EncryptionPolicy getSecondaryEncryptionPolicy() throws PolicyException {
        if (this.sEncPolicy == null) {
            this.sEncPolicy = new EncryptionPolicy();
            this.sEncPolicy.setUUID(this.pid.generateID());
            Token token = null;
            token = this.getEncryptionToken();
            this.tokenProcessor.addKeyBinding(this.sEncPolicy, token, false);
            this.container.insert(this.sEncPolicy);
        }
        return this.sEncPolicy;
    }

    @Override
    protected void close() {
        if (this.protectionOrder == "SignBeforeEncrypting") {
            this.container.insert(this.primaryEP);
        }
    }
}

