/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.wss.provider.wsit.WSITAuthConfigProvider;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ClientAuthContext;

public class WSITClientSecurityPipe
implements Pipe {
    private static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    Pipe nextPipe = null;
    Map properties = null;
    ClientAuthConfig clientConfig = null;
    ClientAuthContext clientAuthContext = null;

    public WSITClientSecurityPipe(WSITClientSecurityPipe that) {
        this.clientConfig = that.clientConfig;
        this.clientAuthContext = that.clientAuthContext;
        this.properties = that.properties;
    }

    public WSITClientSecurityPipe(Map properties, Pipe nextPipe) {
        this.properties = properties;
        this.nextPipe = nextPipe;
        properties.put("NEXT_PIPE", nextPipe);
        properties.put("WSIT_GENERIC_CALLBACK_HANDLER", "true");
        WSITAuthConfigProvider provider = new WSITAuthConfigProvider(properties, null);
        try {
            this.clientConfig = provider.getClientAuthConfig("SOAP", null, null);
            this.clientAuthContext = this.clientConfig.getAuthContext(null, null, properties);
            properties.put("SC_INITIATOR", this.clientAuthContext);
        }
        catch (AuthException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0038_ERROR_CREATING_NEW_INSTANCE_WSIT_CLIENT_SEC_PIPE(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0038_ERROR_CREATING_NEW_INSTANCE_WSIT_CLIENT_SEC_PIPE(), e);
        }
    }

    public Packet process(Packet packet) {
        return null;
    }

    public void preDestroy() {
        try {
            this.clientAuthContext.cleanSubject(null, null);
        }
        catch (AuthException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0040_ERROR_CLEAN_SUBJECT(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0040_ERROR_CLEAN_SUBJECT(), e);
        }
        if (this.nextPipe != null) {
            this.nextPipe.preDestroy();
        }
    }

    public Pipe copy(PipeCloner cloner) {
        Pipe clonedNextPipe = cloner.copy(this.nextPipe);
        WSITClientSecurityPipe copied = new WSITClientSecurityPipe(this);
        copied.setNextPipe(clonedNextPipe);
        cloner.add(this, copied);
        return copied;
    }

    public void setNextPipe(Pipe next) {
        this.nextPipe = next;
    }
}

