/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerInputStream;
import com.iplanet.security.util.DerOutputStream;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.AVA;
import com.iplanet.security.x509.CertParseError;
import com.iplanet.security.x509.LdapDNStrConverter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class RDN {
    private AVA[] assertion;

    public RDN(String rdnString) throws IOException {
        RDN rdn = LdapDNStrConverter.getDefault().parseRDN(rdnString);
        this.assertion = rdn.getAssertion();
    }

    public RDN(String rdnString, byte[] tags) throws IOException {
        RDN rdn = LdapDNStrConverter.getDefault().parseRDN(rdnString, tags);
        this.assertion = rdn.getAssertion();
    }

    public RDN(String rdnString, LdapDNStrConverter ldapDNStrConverter) throws IOException {
        RDN rdn = ldapDNStrConverter.parseRDN(rdnString);
        this.assertion = rdn.getAssertion();
    }

    public RDN(DerValue set) throws IOException {
        int j;
        if (set.tag != 49) {
            throw new CertParseError("X500 RDN");
        }
        int j_max = 50;
        AVA[] avas = new AVA[j_max];
        for (j = 0; j < j_max; ++j) {
            avas[j] = new AVA(set.data);
            if (set.data.available() == 0) break;
        }
        if (j >= j_max - 1) {
            this.assertion = new AVA[j + 1];
        } else {
            this.assertion = new AVA[j + 1];
            for (int i = 0; i < j + 1; ++i) {
                this.assertion[i] = avas[i];
            }
        }
    }

    public RDN(DerInputStream in) throws IOException {
        DerValue[] avaset = in.getSet(1);
        this.assertion = new AVA[avaset.length];
        for (int i = 0; i < this.assertion.length; ++i) {
            this.assertion[i] = new AVA(avaset[i].data);
        }
    }

    public RDN(AVA[] avas) {
        this.assertion = (AVA[])avas.clone();
    }

    public RDN(Vector avaVector) {
        int size = avaVector.size();
        this.assertion = new AVA[size];
        for (int i = 0; i < size; ++i) {
            this.assertion[i] = (AVA)avaVector.elementAt(i);
        }
    }

    public AVA[] getAssertion() {
        return (AVA[])this.assertion.clone();
    }

    public int getAssertionLength() {
        return this.assertion.length;
    }

    public boolean equals(RDN other) {
        if (other == this) {
            return true;
        }
        if (this.assertion.length != other.assertion.length) {
            return false;
        }
        for (int i = 0; i < this.assertion.length; ++i) {
            if (this.assertion[i].equals(other.assertion[i])) continue;
            return false;
        }
        return true;
    }

    DerValue findAttribute(ObjectIdentifier oid) {
        for (int i = 0; i < this.assertion.length; ++i) {
            if (!this.assertion[i].oid.equals(oid)) continue;
            return this.assertion[i].value;
        }
        return null;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.assertion.length; ++i) {
            this.assertion[i].encode(tmp);
        }
        out.write((byte)49, tmp);
    }

    public Enumeration getAVAs() {
        return new AVAEnumerator();
    }

    public String toLdapDNString() throws IOException {
        return LdapDNStrConverter.getDefault().encodeRDN(this);
    }

    public String toLdapDNString(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        return ldapDNStrConverter.encodeRDN(this);
    }

    public String toString() {
        String s;
        try {
            s = this.toLdapDNString();
        }
        catch (IOException e) {
            return null;
        }
        return s;
    }

    private class AVAEnumerator
    implements Enumeration {
        private int index = 0;

        public boolean hasMoreElements() {
            return this.index < RDN.this.assertion.length;
        }

        public Object nextElement() {
            if (this.index >= RDN.this.assertion.length) {
                return null;
            }
            return RDN.this.assertion[this.index++];
        }
    }
}

