/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc;

import com.sun.identity.liberty.ws.authnsvc.AuthnSvcException;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcService;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.mechanism.MechanismHandler;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLRequest;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLResponse;
import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.RequestHandler;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.w3c.dom.Element;

public final class AuthnSvcRequestHandlerImpl
implements RequestHandler {
    public AuthnSvcRequestHandlerImpl() {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("AuthnSvcRequestHanderImpl constructor.");
        }
    }

    public Message processRequest(Message request) throws AuthnSvcException {
        List list = request.getBodies("urn:liberty:sa:2004-04", "SASLRequest");
        if (list.isEmpty()) {
            throw new AuthnSvcException("missingSASLRequet");
        }
        if (list.size() > 1) {
            throw new AuthnSvcException("tooManySASLRequet");
        }
        SASLRequest saslReq = new SASLRequest((Element)list.get(0));
        saslReq.setMessageID(request.getCorrelationHeader().getMessageID());
        saslReq.setRefToMessageID(request.getCorrelationHeader().getRefToMessageID());
        Message message = new Message();
        String respMessageID = message.getCorrelationHeader().getMessageID();
        SASLResponse saslResp = AuthnSvcRequestHandlerImpl.processSASLRequest(saslReq, request, respMessageID);
        message.setSOAPBody(saslResp.toElement());
        return message;
    }

    private static SASLResponse processSASLRequest(SASLRequest saslReq, Message message, String respMessageID) throws AuthnSvcException {
        String mech;
        String mechanism = saslReq.getMechanism().trim();
        if (AuthnSvcUtils.debug.messageEnabled()) {
            String msg = AuthnSvcUtils.getString("messageID") + "=" + message.getCorrelationHeader().getMessageID() + ", " + AuthnSvcUtils.getString("mechanism") + "=" + mechanism + ", " + AuthnSvcUtils.getString("authzID") + "=" + saslReq.getAuthzID() + ", " + AuthnSvcUtils.getString("advisoryAuthnID") + "=" + saslReq.getAdvisoryAuthnID();
            AuthnSvcUtils.debug.message(msg);
        }
        String[] data = new String[]{message.getCorrelationHeader().getMessageID(), mechanism, saslReq.getAuthzID(), saslReq.getAdvisoryAuthnID()};
        if (mechanism.length() == 0) {
            if (AuthnSvcUtils.debug.messageEnabled()) {
                AuthnSvcUtils.debug.message("AuthnSvcRequestHanderImpl.processSASLRequest: mechanism is empty");
            }
            if (LogUtil.isLogEnabled()) {
                LogUtil.access(Level.INFO, "AS_Abort", data);
            }
            return new SASLResponse("abort");
        }
        MechanismHandler mechanismHandler = null;
        StringTokenizer stz = new StringTokenizer(mechanism);
        while (stz.hasMoreTokens() && (mechanismHandler = AuthnSvcService.getMechanismHandler(mech = stz.nextToken())) == null) {
        }
        if (mechanismHandler == null) {
            if (AuthnSvcUtils.debug.messageEnabled()) {
                AuthnSvcUtils.debug.message("AuthnSvcRequestHanderImpl.processSASLRequest: Unable to find mechanismHandler");
            }
            if (LogUtil.isLogEnabled()) {
                LogUtil.access(Level.INFO, "AS_Abort", data);
            }
            return new SASLResponse("abort");
        }
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("AuthnSvcRequestHanderImpl.processSASLRequest: mechanismHandler = " + mechanismHandler.getClass());
        }
        SASLResponse saslResp = mechanismHandler.processSASLRequest(saslReq, message, respMessageID);
        if (LogUtil.isLogEnabled()) {
            String statusCode = saslResp.getStatusCode();
            if (statusCode.equals("OK")) {
                LogUtil.access(Level.INFO, "AS_OK", data);
            } else if (statusCode.equals("continue")) {
                LogUtil.access(Level.INFO, "AS_Continue", data);
            } else {
                LogUtil.access(Level.INFO, "AS_Abort", data);
            }
        }
        return saslResp;
    }
}

