/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;

class PolicyEvaluatorFactory {
    private static final int CACHE_SIZE = 100;
    private static PolicyEvaluatorFactory policyEvaluatorFactory;
    private Cache evaluatorCache = new Cache(100);

    private PolicyEvaluatorFactory() {
    }

    public static synchronized PolicyEvaluatorFactory getInstance() throws PolicyException {
        if (policyEvaluatorFactory == null) {
            policyEvaluatorFactory = new PolicyEvaluatorFactory();
        }
        return policyEvaluatorFactory;
    }

    public synchronized PolicyEvaluator getPolicyEvaluator(SSOToken token, String serviceType) throws NameNotFoundException, PolicyException, SSOException {
        PolicyEvaluator pe = (PolicyEvaluator)this.evaluatorCache.get(serviceType);
        if (pe == null) {
            if (PolicyManager.debug.messageEnabled()) {
                PolicyManager.debug.message(" User: " + token.getPrincipal().getName() + " created policy evaluator (using " + " PolicyEvaluatorFactory)  for " + " for serviceType: " + serviceType);
            }
            pe = new PolicyEvaluator(serviceType);
            this.evaluatorCache.put(serviceType, pe);
            if (PolicyManager.debug.messageEnabled()) {
                PolicyManager.debug.message(" User: " + token.getPrincipal().getName() + " got policy evaluator " + " (using PolicyEvaluatorFactory) for " + " for serviceType: " + serviceType);
            }
        }
        return pe;
    }
}

