/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import org.w3c.dom.Element;

public class SubjectLocality {
    static SAMLConstants sc;
    private String _ipAddress = null;
    private String _dnsAddress = null;

    public SubjectLocality() {
    }

    public SubjectLocality(Element localityElement) throws SAMLException {
        Element elt = localityElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SubjectLocality: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!eltName.equals("SubjectLocality")) {
            throw new SAMLException("invalidElement");
        }
        String read = elt.getAttribute("IPAddress");
        if (read != null && read.length() != 0) {
            this._ipAddress = read;
        }
        if ((read = elt.getAttribute("DNSAddress")) != null && read.length() != 0) {
            this._dnsAddress = read;
        }
    }

    public SubjectLocality(String ipAddress, String dnsAddress) {
        this._ipAddress = ipAddress == null ? "" : ipAddress;
        this._dnsAddress = dnsAddress == null ? "" : dnsAddress;
    }

    public String getIPAddress() {
        return this._ipAddress;
    }

    public boolean setDNSAddress(String dnsAddress) {
        if (dnsAddress == null || dnsAddress.length() == 0) {
            SAMLUtilsCommon.debug.message("DNS Address is null");
            return false;
        }
        this._dnsAddress = dnsAddress;
        return true;
    }

    public boolean setIPAddress(String ipAddress) {
        if (ipAddress == null || ipAddress.length() == 0) {
            SAMLUtilsCommon.debug.message("IP Address is null");
            return false;
        }
        this._ipAddress = ipAddress;
        return true;
    }

    public String getDNSAddress() {
        return this._dnsAddress;
    }

    public String toString() {
        String xml = this.toString(true, false);
        return xml;
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(3000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        if (includeNS) {
            appendNS = "saml:";
        }
        xml.append("<").append(appendNS).append("SubjectLocality").append(" ").append(NS).append(" ");
        if (this._ipAddress != null && this._ipAddress.length() != 0) {
            xml.append("IPAddress").append("=\"").append(this._ipAddress).append("\"").append(" ");
        }
        if (this._dnsAddress != null && this._dnsAddress.length() != 0) {
            xml.append("DNSAddress").append("=\"").append(this._dnsAddress).append("\"").append(" ");
        }
        xml.append("/>");
        return xml.toString();
    }
}

