/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.ManageNameIDResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.impl.StatusResponseImpl;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManageNameIDResponseImpl
extends StatusResponseImpl
implements ManageNameIDResponse {
    public final String elementName = "ManageNameIDResponse";

    public ManageNameIDResponseImpl() {
        this.isMutable = true;
    }

    public ManageNameIDResponseImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
        if (this.isSigned) {
            this.signedXMLString = XMLUtils.print(element);
        }
        this.makeImmutable();
    }

    public ManageNameIDResponseImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument(xmlString, SAMLUtils.debug);
        if (doc == null) {
            throw new SAML2Exception("errorObtainingElement");
        }
        this.parseElement(doc.getDocumentElement());
        if (this.isSigned) {
            this.signedXMLString = xmlString;
        }
        this.makeImmutable();
    }

    private void parseElement(Element element) throws SAML2Exception {
        AssertionFactory af = AssertionFactory.getInstance();
        ProtocolFactory pf = ProtocolFactory.getInstance();
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ManageNameIDResponseImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("ManageNameIDResponse")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ManageNameIDResponseImpl.parseElement:not ManageNameIDResponse.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        this.responseId = element.getAttribute("ID");
        this.validateID(this.responseId);
        this.version = element.getAttribute("Version");
        this.validateVersion(this.version);
        String issueInstantStr = element.getAttribute("IssueInstant");
        this.validateIssueInstant(issueInstantStr);
        this.destination = element.getAttribute("Destination");
        this.consent = element.getAttribute("Consent");
        this.inResponseTo = element.getAttribute("InResponseTo");
        NodeList nList = element.getChildNodes();
        if (nList != null && nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node childNode = nList.item(i);
                String cName = childNode.getLocalName();
                if (cName == null) continue;
                if (cName.equals("Issuer")) {
                    this.issuer = af.createIssuer((Element)childNode);
                    continue;
                }
                if (cName.equals("Signature")) {
                    this.signatureString = XMLUtils.getElementString((Element)childNode);
                    this.isSigned = true;
                    continue;
                }
                if (cName.equals("Extensions")) {
                    this.extensions = pf.createExtensions((Element)childNode);
                    continue;
                }
                if (!cName.equals("Status")) continue;
                this.status = pf.createStatus((Element)childNode);
            }
        }
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        if (this.isSigned && this.signedXMLString != null) {
            return this.signedXMLString;
        }
        StringBuffer xml = new StringBuffer();
        String NS = "";
        String NSP = "";
        if (declareNS) {
            NS = " xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"";
        }
        if (includeNSPrefix) {
            NSP = "samlp:";
        }
        xml.append("<").append(NSP).append("ManageNameIDResponse").append(" ");
        xml.append(super.toXMLString(includeNSPrefix, includeNSPrefix));
        xml.append("</").append(NSP).append("ManageNameIDResponse").append(">");
        return xml.toString();
    }
}

