/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.StatusCode;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StatusCodeImpl
implements StatusCode {
    private boolean isMutable = false;
    private StatusCode statusCode = null;
    private String statusCodeValue = null;

    public StatusCodeImpl() {
        this.isMutable = true;
    }

    public StatusCodeImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public StatusCodeImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.statusCode = value;
    }

    public String getValue() {
        return this.statusCodeValue;
    }

    public void setValue(String value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.statusCodeValue = value;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        String xmlStr = null;
        if (this.statusCodeValue != null && this.statusCodeValue.length() != 0) {
            StringBuffer xmlString = new StringBuffer(500);
            xmlString.append("<");
            if (includeNSPrefix) {
                xmlString.append("samlp:");
            }
            xmlString.append("StatusCode").append(" ");
            if (declareNS) {
                xmlString.append(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"").append("\n");
            }
            xmlString.append("Value").append("=").append("\"").append(this.statusCodeValue).append("\"");
            xmlString.append(">");
            if (this.statusCode != null) {
                xmlString.append("\n").append(this.statusCode.toXMLString(includeNSPrefix, declareNS));
            }
            xmlString.append("\n").append("</samlp:").append("StatusCode").append(">");
            xmlStr = xmlString.toString();
        }
        return xmlStr;
    }

    public void makeImmutable() {
        if (this.isMutable) {
            if (this.statusCode != null && this.statusCode.isMutable()) {
                this.statusCode.makeImmutable();
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    private void parseElement(Element element) throws SAML2Exception {
        ProtocolFactory protoFactory = ProtocolFactory.getInstance();
        this.statusCodeValue = element.getAttribute("Value");
        this.validateStatusCodeValue(this.statusCodeValue);
        NodeList nList = element.getChildNodes();
        if (nList != null && nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node childNode = nList.item(i);
                String cName = childNode.getLocalName();
                if (cName == null || !cName.equals("StatusCode")) continue;
                this.statusCode = protoFactory.createStatusCode((Element)childNode);
            }
        }
    }

    void validateStatusCodeValue(String statusCodeValue) throws SAML2Exception {
        if (statusCodeValue == null || statusCodeValue.length() == 0) {
            SAML2SDKUtils.debug.message("statusCodeValue is required");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingStatusCodeValue"));
        }
    }
}

