/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.locale;

import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.L10NMessage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class L10NMessageImpl
extends Exception
implements L10NMessage {
    private static final long serialVersionUID = -4690604178832156822L;
    private AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private String message;
    private String bundleName;
    private String errorCode;
    private Object[] args;
    private ResourceBundle bundle;

    public L10NMessageImpl(String msg) {
        super(msg);
    }

    public L10NMessageImpl(String rbName, String errorCode, Object[] args) {
        this.bundleName = rbName;
        this.errorCode = errorCode;
        this.args = args;
        this.message = this.getL10NMessage(Locale.ENGLISH);
    }

    public L10NMessageImpl(Throwable ex) {
        this.message = ex.getMessage();
        if (ex instanceof L10NMessage) {
            L10NMessage lex = (L10NMessage)((Object)ex);
            this.bundleName = lex.getResourceBundleName();
            this.errorCode = lex.getErrorCode();
            this.args = lex.getMessageArgs();
        }
    }

    public String getL10NMessage(Locale locale) {
        if (this.errorCode == null) {
            return this.getMessage();
        }
        String result = this.message;
        if (this.bundleName != null && locale != null) {
            this.bundle = this.amCache.getResBundle(this.bundleName, locale);
            String mid = this.bundle.getString(this.errorCode);
            result = this.args == null || this.args.length == 0 ? mid : MessageFormat.format(mid, this.args);
        }
        return result;
    }

    public String getResourceBundleName() {
        return this.bundleName;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return super.getMessage();
    }
}

