/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCrypt;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Map;
import java.util.Set;

class AMTemplateImpl
extends AMObjectImpl
implements AMTemplate {
    private String serviceName;
    private int type;
    private ServiceSchema serviceSchema = null;
    static String cospriorityAN = "cospriority";

    public AMTemplateImpl(SSOToken ssoToken, String DN2, String serviceName, int type) throws AMException, SSOException {
        super(ssoToken, DN2, 13);
        this.serviceName = serviceName;
        this.type = type;
        this.profileType = type;
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, ssoToken);
            this.serviceSchema = type == 300 ? ssm.getPolicySchema() : ssm.getDynamicSchema();
            if (this.serviceSchema == null) {
                if (debug.warningEnabled()) {
                    debug.warning("AMTemplateImpl:" + AMSDKBundle.getString("484"));
                }
                throw new AMException(AMSDKBundle.getString("484"), "484");
            }
        }
        catch (SMSException smsex) {
            if (debug.warningEnabled()) {
                debug.warning("AMTemplateImpl:", smsex);
            }
            throw new AMException(AMSDKBundle.getString("484"), "484");
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Set getAttributeSchemas() throws AMException, SSOException {
        return this.serviceSchema.getAttributeSchemas();
    }

    public int getPriority() throws SSOException {
        try {
            return this.getIntegerAttribute(cospriorityAN);
        }
        catch (AMException e) {
            debug.message("AMTemplateImpl.getPriority", e);
            return -1;
        }
    }

    public void setPriority(int priority) throws AMException, SSOException {
        this.setIntegerAttribute(cospriorityAN, priority);
        this.store();
    }

    public int getType() {
        return this.type;
    }

    public Set getPolicyNames() throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public void setAttributes(Map attributes) throws AMException, SSOException {
        attributes = AMCrypt.encryptPasswords(attributes, this.serviceSchema);
        try {
            this.serviceSchema.validateAttributes(attributes);
        }
        catch (SMSException smsex) {
            debug.error("AMTemplateImpl.setAttributes", smsex);
            throw new AMException(AMSDKBundle.getString("334"), "334");
        }
        super.setAttributes(attributes);
    }

    public Set getAttribute(String attributeName) throws AMException, SSOException {
        Set values = super.getAttribute(attributeName);
        return AMCrypt.decryptPasswords(values, attributeName, this.serviceSchema);
    }

    public Map getAttributes(Set attributeNames) throws AMException, SSOException {
        Map attributes = super.getAttributes(attributeNames);
        attributes = AMCrypt.decryptPasswords(attributes, this.serviceSchema);
        return attributes;
    }
}

