/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.security.SecurityUtils;
import com.sun.identity.liberty.ws.soapbinding.CorrelationHeader;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.RequestHandler;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingService;
import com.sun.identity.liberty.ws.soapbinding.SOAPFault;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.liberty.ws.soapbinding.WebServiceAuthenticator;
import com.sun.identity.saml.common.SAMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAPReceiver
extends HttpServlet {
    private static MessageFactory msgFactory = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            msgFactory = MessageFactory.newInstance();
        }
        catch (SOAPException ex) {
            Utils.debug.error("SOAPReceiver.init: create message factory failed.");
            throw new ServletException(ex.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            MimeHeaders mimeHeaders = SAMLUtils.getMimeHeaders(request);
            ServletInputStream sInputStream = request.getInputStream();
            SOAPMessage soapMessage = msgFactory.createMessage(mimeHeaders, (InputStream)sInputStream);
            SOAPMessage soapMessageReply = this.onMessage(soapMessage, request);
            if (soapMessageReply != null) {
                SAMLUtils.setMimeHeaders(soapMessageReply.getMimeHeaders(), response);
                ServletOutputStream sOutputStream = response.getOutputStream();
                soapMessageReply.writeTo((OutputStream)sOutputStream);
                sOutputStream.flush();
            } else {
                response.setStatus(500);
            }
        }
        catch (SOAPException se) {
            throw new ServletException((Throwable)se);
        }
    }

    public SOAPMessage onMessage(SOAPMessage message, HttpServletRequest request) {
        String key;
        String soapAction;
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("SOAPReceiver.onMessage:");
        }
        if ((soapAction = request.getHeader("SOAPAction")) != null && soapAction.length() == 0) {
            soapAction = request.getRequestURI();
        }
        String remoteAddr = request.getRemoteAddr();
        X509Certificate[] allCerts = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        X509Certificate certificate = null;
        if (allCerts != null && allCerts.length > 0) {
            certificate = allCerts[0];
        }
        if ((key = request.getPathInfo()) != null) {
            RequestHandler handler;
            key = key.substring(1);
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("SOAPReceiver.doPost: key = " + key + "\nSOAPAction = " + soapAction + "\nremoteAttr = " + remoteAddr);
            }
            if ((handler = (RequestHandler)SOAPBindingService.handlers.get(key)) != null) {
                List supportedSOAPActions;
                if (soapAction != null && (supportedSOAPActions = (List)SOAPBindingService.supportedSOAPActionsMap.get(key)) != null && !supportedSOAPActions.isEmpty() && !supportedSOAPActions.contains(soapAction)) {
                    return this.FormSOAPError("Client", "unsupportedSOAPAction", null);
                }
                Message req = null;
                try {
                    req = new Message(message);
                    Utils.enforceProcessingRules(req, null, true);
                    req.setIPAddress(remoteAddr);
                    req.setPeerCertificate(certificate);
                    req.setProtocol(request.getScheme());
                    if (req.getSecurityProfileType() != 0 && !SecurityUtils.verifyMessage(req)) {
                        return this.FormSOAPError("Client", "cannotVerifySignature", req);
                    }
                    String authMech = req.getAuthenticationMechanism();
                    if (Utils.debug.messageEnabled()) {
                        Utils.debug.message("SOAPReceiver.onMessage: authMech = " + authMech + ", isClientAuthentication = " + req.isClientAuthentication());
                    }
                    if (authMech == null || !SOAPBindingService.getSupportedAuthenticationMechanisms().contains(authMech)) {
                        return this.FormSOAPError("Server", "unsupportedAuthMech", req);
                    }
                    WebServiceAuthenticator wsAuthenticator = SOAPBindingService.getWebServiceAuthenticator();
                    if (wsAuthenticator == null) {
                        return this.FormSOAPError("Server", "noWSAuthentication", req);
                    }
                    Object token = wsAuthenticator.authenticate(req, null, null, request);
                    req.setToken(token);
                    String[] data = new String[]{req.getCorrelationHeader().getMessageID(), key};
                    LogUtil.access(Level.INFO, "WS_Success", data);
                    Message resp = handler.processRequest(req);
                    resp.getCorrelationHeader().setRefToMessageID(req.getCorrelationHeader().getMessageID());
                    int securityProfileType = resp.getSecurityProfileType();
                    if (securityProfileType == 0 || securityProfileType == 3) {
                        return resp.toSOAPMessage();
                    }
                    Element sigElem = SecurityUtils.signMessage(resp);
                    if (sigElem == null) {
                        Utils.debug.error("SOAPReceiver.onMessage: Unable to sign response");
                        return this.FormSOAPError("Server", "cannotSignResponse", req);
                    }
                    Document doc = sigElem.getOwnerDocument();
                    return Utils.DocumentToSOAPMessage(doc);
                }
                catch (SOAPFaultException sfe) {
                    Message sfmsg = sfe.getSOAPFaultMessage();
                    if (sfmsg == null) {
                        return this.FormSOAPError("Server", "unknownError", req);
                    }
                    if (Utils.debug.messageEnabled()) {
                        Utils.debug.message("SOAPReceiver.onMessage: got SOAPFaultException", sfe);
                    }
                    try {
                        CorrelationHeader corrH;
                        if (req != null && (corrH = sfmsg.getCorrelationHeader()) != null) {
                            corrH.setRefToMessageID(req.getCorrelationHeader().getMessageID());
                        }
                        return sfmsg.toSOAPMessage();
                    }
                    catch (Exception ex) {
                        Utils.debug.message("SOAPReceiver.onMessage: ", ex);
                        return this.FormSOAPError("Server", ex, req);
                    }
                }
                catch (Throwable t) {
                    Utils.debug.message("SOAPReceiver.onMessage: ", t);
                    return this.FormSOAPError("Server", t, req);
                }
            }
            return this.FormSOAPError("Server", "missingRequestHandler", null);
        }
        return this.FormSOAPError("Server", "missingKey", null);
    }

    private SOAPMessage FormSOAPError(String faultCode, Throwable throwable, Message req) {
        String faultString = throwable.getMessage();
        if (faultString == null || faultString.length() == 0) {
            faultString = Utils.bundle.getString("unknownError");
        }
        return this.FormSOAPError(req, faultCode, faultString);
    }

    private SOAPMessage FormSOAPError(String faultCode, String faultStringKey, Message req) {
        String faultString = Utils.bundle.getString(faultStringKey);
        return this.FormSOAPError(req, faultCode, faultString);
    }

    private SOAPMessage FormSOAPError(Message req, String faultCode, String faultString) {
        String logMsg = req == null ? faultString : Utils.bundle.getString("messageID") + "=" + req.getCorrelationHeader().getMessageID() + ". " + faultString;
        String[] data = new String[]{logMsg};
        LogUtil.error(Level.INFO, "WS_Failure", data);
        try {
            SOAPFault sf = new SOAPFault(new QName("http://schemas.xmlsoap.org/soap/envelope/", faultCode), faultString);
            Message resp = new Message(sf);
            return resp.toSOAPMessage();
        }
        catch (Exception e) {
            Utils.debug.error("SOAPReceiver.FormSOAPError: ", e);
            return null;
        }
    }
}

