/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.L10NMessage;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

class ChainedException
extends Exception
implements L10NMessage {
    private String _message;
    private Throwable _nestedException;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private String _bundleName;
    private String _errorCode;
    private Object[] _args;
    private ResourceBundle _bundle;

    public ChainedException(String message, Throwable nestedException) {
        this._message = message;
        this._nestedException = nestedException;
    }

    public ChainedException(Throwable nestedException) {
        this._nestedException = nestedException;
        if (this._nestedException instanceof L10NMessage) {
            L10NMessage lex = (L10NMessage)((Object)this._nestedException);
            this._message = lex.getMessage();
            this._bundleName = lex.getResourceBundleName();
            this._errorCode = lex.getErrorCode();
            this._args = lex.getMessageArgs();
        }
    }

    public ChainedException(String message) {
        this._message = message;
    }

    public ChainedException(String rbName, String errorCode, Object[] args, Throwable nestedException) {
        this._bundleName = rbName;
        this._errorCode = errorCode;
        this._args = args;
        this._nestedException = nestedException;
        this._message = this.getCompleteL10NMessage(Locale.ENGLISH);
    }

    public String getL10NMessage(Locale locale) {
        String result = this._message;
        if (this._errorCode != null && this._bundleName != null && locale != null) {
            this._bundle = amCache.getResBundle(this._bundleName, locale);
            String mid = this._bundle.getString(this._errorCode);
            result = this._args == null || this._args.length == 0 ? mid : MessageFormat.format(mid, this._args);
        }
        return result;
    }

    public String getCompleteL10NMessage(Locale locale) {
        String result = this._message;
        if (this._errorCode != null && this._bundleName != null && locale != null) {
            this._bundle = amCache.getResBundle(this._bundleName, locale);
            String mid = this._bundle.getString(this._errorCode);
            result = this._args == null || this._args.length == 0 ? mid : MessageFormat.format(mid, this._args);
        }
        String chainedMessage = null;
        if (this._nestedException != null) {
            if (this._nestedException instanceof L10NMessage) {
                L10NMessage lex = (L10NMessage)((Object)this._nestedException);
                chainedMessage = lex.getL10NMessage(locale);
            } else {
                chainedMessage = this._nestedException.getMessage();
            }
        }
        if (chainedMessage != null) {
            result = result != null ? result + "\n" + chainedMessage : chainedMessage;
        }
        return result;
    }

    public String getResourceBundleName() {
        return this._bundleName;
    }

    public String getErrorCode() {
        return this._errorCode;
    }

    public Object[] getMessageArgs() {
        return this._args;
    }

    public String getMessage() {
        String message = this._message;
        String chainedMessage = null;
        if (this._nestedException != null) {
            chainedMessage = this._nestedException.getMessage();
        }
        message = chainedMessage != null ? (message != null ? this._message + "\n" + chainedMessage : chainedMessage) : this._message;
        return message;
    }

    public void printStackTrace() {
        System.err.println(this.fetchStackTrace());
    }

    public void printStackTrace(PrintWriter pw) {
        pw.println(this.fetchStackTrace());
    }

    public void printStackTrace(PrintStream ps) {
        ps.println(this.fetchStackTrace());
    }

    private String getLocalMessage() {
        return this._message;
    }

    private String fetchStackTrace() {
        String stackString = null;
        StringBuffer messageBuffer = new StringBuffer();
        int exCount = 1;
        Throwable rootException = this;
        messageBuffer.append(rootException.getClass().getName() + "(" + exCount + ")" + ":" + ((ChainedException)rootException).getLocalMessage() + "\n");
        while (rootException instanceof ChainedException && ((ChainedException)rootException)._nestedException != null) {
            rootException = ((ChainedException)rootException)._nestedException;
            ++exCount;
            if (rootException instanceof ChainedException) {
                messageBuffer.append(rootException.getClass().getName() + "(" + exCount + ")" + ":" + ((ChainedException)rootException).getLocalMessage() + "\n");
                continue;
            }
            messageBuffer.append(rootException.getClass().getName() + "(" + exCount + ")" + ":" + rootException.getMessage() + "\n");
        }
        if (rootException == this) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ((ChainedException)rootException).printExceptionStackTrace(pw);
            stackString = sw.getBuffer().toString();
        } else {
            StringWriter rootStackWriter = new StringWriter();
            StringWriter thisStackWriter = new StringWriter();
            rootException.printStackTrace(new PrintWriter(rootStackWriter));
            this.printExceptionStackTrace(new PrintWriter(thisStackWriter));
            StringBuffer rootStackTrace = rootStackWriter.getBuffer();
            rootStackTrace.insert(0, messageBuffer.toString());
            stackString = rootStackTrace.toString();
        }
        return stackString;
    }

    private void printExceptionStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
    }

    public Throwable getNestedException() {
        return this._nestedException;
    }
}

